/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPInput;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputData;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputField;
import org.pentaho.di.trans.steps.ldapinput.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean useAuthentication;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private String Host;
    private String userName;
    private String password;
    private String port;
    private String filterString;
    private String searchBase;
    private LDAPInputField[] inputFields;
    private int timeLimit;
    private String multiValuedSeparator;
    private static final String YES = "Y";
    public static final String[] type_trim_code = new String[]{"none", "left", "right", "both"};

    public boolean UseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public LDAPInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LDAPInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String getHost() {
        return this.Host;
    }

    public void setHost(String host) {
        this.Host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        LDAPInputMeta retval = (LDAPInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LDAPInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"useauthentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"host", (String)this.Host));
        retval.append("    ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filterstring", (String)this.filterString));
        retval.append("    ").append(XMLHandler.addTagValue((String)"searchbase", (String)this.searchBase));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attribute", (String)this.inputFields[i].getAttribute()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timelimit", (int)this.timeLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"multivaluedseparator", (String)this.multiValuedSeparator));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.useAuthentication = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useauthentication"));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.Host = XMLHandler.getTagValue((Node)stepnode, (String)"host");
            this.userName = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password")));
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.filterString = XMLHandler.getTagValue((Node)stepnode, (String)"filterstring");
            this.searchBase = XMLHandler.getTagValue((Node)stepnode, (String)"searchbase");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = new LDAPInputField();
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setAttribute(XMLHandler.getTagValue((Node)fnode, (String)"attribute"));
                this.inputFields[i].setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XMLHandler.getTagValue((Node)fnode, (String)"repeat");
                this.inputFields[i].setTrimType(LDAPInputMeta.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.timeLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"timelimit"), (int)0);
            this.multiValuedSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"multivaluedseparator");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("LDAPInputMeta.UnableToLoadFromXML"), (Throwable)e);
        }
    }

    public void allocate(int nrfields) {
        this.inputFields = new LDAPInputField[nrfields];
    }

    @Override
    public void setDefault() {
        this.useAuthentication = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.Host = "";
        this.userName = "";
        this.password = "";
        this.port = "389";
        this.filterString = "objectclass=*";
        this.searchBase = "";
        this.multiValuedSeparator = ";";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LDAPInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.timeLimit = 0;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            LDAPInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v.setLength(field.getLength(), field.getPrecision());
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trim_code.length; ++i) {
                if (!type_trim_code[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.useAuthentication = rep.getStepAttributeBoolean(id_step, "useauthentication");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.Host = rep.getStepAttributeString(id_step, "host");
            this.userName = rep.getStepAttributeString(id_step, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.port = rep.getStepAttributeString(id_step, "port");
            this.filterString = rep.getStepAttributeString(id_step, "filterstring");
            this.searchBase = rep.getStepAttributeString(id_step, "searchbase");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.timeLimit = (int)rep.getStepAttributeInteger(id_step, "timelimit");
            this.multiValuedSeparator = rep.getStepAttributeString(id_step, "multivaluedseparator");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                LDAPInputField field = new LDAPInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setAttribute(rep.getStepAttributeString(id_step, i, "field_attribute"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(LDAPInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDAPInputMeta.Exception.ErrorReadingRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "useauthentication", this.useAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "host", this.Host);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.userName);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "filterstring", this.filterString);
            rep.saveStepAttribute(id_transformation, id_step, "searchbase", this.searchBase);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "timelimit", this.timeLimit);
            rep.saveStepAttribute(id_transformation, id_step, "multivaluedseparator", this.multiValuedSeparator);
            for (int i = 0; i < this.inputFields.length; ++i) {
                LDAPInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_attribute", field.getAttribute());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDAPInputMeta.Exception.ErrorSavingToRepository", "" + id_step), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = this.inputFields.length == 0 ? new CheckResult(4, Messages.getString("LDAPInputMeta.CheckResult.NoOutputFields"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("LDAPInputMeta.CheckResult.OutputFieldsOk"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(4, Messages.getString("LDAPInputMeta.CheckResult.NoInputExpected"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("LDAPInputMeta.CheckResult.NoInput"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.Host) ? new CheckResult(4, Messages.getString("LDAPInputMeta.CheckResult.HostnameMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("LDAPInputMeta.CheckResult.HostnameOk"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.searchBase) ? new CheckResult(3, Messages.getString("LDAPInputMeta.CheckResult.SearchBaseMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("LDAPInputMeta.CheckResult.SearchBaseOk"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.filterString) ? new CheckResult(3, Messages.getString("LDAPInputMeta.CheckResult.FilterStringMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("LDAPInputMeta.CheckResult.FilterStringOk"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new LDAPInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LDAPInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

