/*==============================================================================

  core_pins.h - Pin definitions.

  Copyright 2010 Rowdy Dog Software.
  Copyright 2015~2018 Spence Konde

  This file is part of ATTinyCore

  ATTinyCore is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation, either version 3 of the License, or (at your
  option) any later version.

  ATTinyCore is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with ATTinyCore.  If not, see <http://www.gnu.org/licenses/>.

==============================================================================*/

#ifndef core_pins_h
#define core_pins_h

#include "core_build_options.h"


/*=============================================================================
  Pin definitions for the ATtinyX41
=============================================================================*/
#if defined( __AVR_ATtinyX41__ )

#ifdef OLD_PINOUT

#define PIN_A0  (10)
#define PIN_A1  ( 9)
#define PIN_A2  ( 8)
#define PIN_A3  ( 7)
#define PIN_A4  ( 6)
#define PIN_A5  ( 5)
#define PIN_A6  ( 4)
#define PIN_A7  ( 3)
#define PIN_B0  ( 0)
#define PIN_B1  ( 1)
#define PIN_B2  ( 2)
#define PIN_B3  (11)  /* RESET */

#define PIN_PA0  (10)
#define PIN_PA1  ( 9)
#define PIN_PA2  ( 8)
#define PIN_PA3  ( 7)
#define PIN_PA4  ( 6)
#define PIN_PA5  ( 5)
#define PIN_PA6  ( 4)
#define PIN_PA7  ( 3)
#define PIN_PB0  ( 0)
#define PIN_PB1  ( 1)
#define PIN_PB2  ( 2)
#define PIN_PB3  (11)  /* RESET */

#define PINMAPPING_CCW

#else

#define PIN_PA0  ( 0)
#define PIN_PA1  ( 1)
#define PIN_PA2  ( 2)
#define PIN_PA3  ( 3)
#define PIN_PA4  ( 4)
#define PIN_PA5  ( 5)
#define PIN_PA6  ( 6)
#define PIN_PA7  ( 7)
#define PIN_PB0  ( 10)
#define PIN_PB1  ( 9)
#define PIN_PB2  ( 8)
#define PIN_PB3  (11)  /* RESET */

#define PIN_A0  ( 0)
#define PIN_A1  ( 1)
#define PIN_A2  ( 2)
#define PIN_A3  ( 3)
#define PIN_A4  ( 4)
#define PIN_A5  ( 5)
#define PIN_A6  ( 6)
#define PIN_A7  ( 7)
#define PIN_B0  ( 10)
#define PIN_B1  ( 9)
#define PIN_B2  ( 8)
#define PIN_B3  (11)  /* RESET */

#define PINMAPPING_CW

#endif

#define LED_BUILTIN (PIN_PB2)

#define CORE_DIGITAL_FIRST    (0)
#define CORE_DIGITAL_LAST     (11)
#define CORE_DIGITAL_COUNT    (CORE_DIGITAL_LAST-CORE_DIGITAL_FIRST+1)
#define CORE_RESET_INCLUDED   (1)

#define CORE_ANALOG_FIRST     (64)
#define CORE_ANALOG_COUNT     (12)
#define CORE_ANALOG_LAST      (CORE_ANALOG_FIRST+CORE_ANALOG_COUNT-1)

#define NUM_DIGITAL_PINS            12
#define NUM_ANALOG_INPUTS           12

#define CORE_INT0_PIN  PIN_B1
#define digitalPinToInterrupt(p)  ((p) == CORE_INT0_PIN ? 0 : NOT_AN_INTERRUPT)
// ATtiny841 Datasheet Table 12-7, TOCCn pins can be assigned various OCnX. Rationale for these choices is that - TOCC0/1 are the primary pins for UART0, while TOCC3/4 are shared with UART1. So might as well make them the least desirable timer.
#define CORE_OC0A_PIN  PIN_PA4 // TOCC3
#define CORE_OC0B_PIN  PIN_PA5 // TOCC4
#define CORE_OC1A_PIN  PIN_PA6 // TOCC5
#define CORE_OC1B_PIN  PIN_PA3 // TOCC2
#define CORE_OC2A_PIN  PIN_PB2 // TOCC7
#define CORE_OC2B_PIN  PIN_PA7 // TOCC6

#define CORE_PWM0_PIN       CORE_OC0A_PIN
#define CORE_PWM0_TIMER     0
#define CORE_PWM0_CHANNEL   A

#define CORE_PWM1_PIN       CORE_OC0B_PIN
#define CORE_PWM1_TIMER     0
#define CORE_PWM1_CHANNEL   B

#define CORE_PWM2_PIN       CORE_OC1A_PIN
#define CORE_PWM2_TIMER     1
#define CORE_PWM2_CHANNEL   A

#define CORE_PWM3_PIN       CORE_OC1B_PIN
#define CORE_PWM3_TIMER     1
#define CORE_PWM3_CHANNEL   B

#define CORE_PWM4_PIN       CORE_OC2A_PIN
#define CORE_PWM4_TIMER     2
#define CORE_PWM4_CHANNEL   A

#define CORE_PWM5_PIN       CORE_OC2B_PIN
#define CORE_PWM5_TIMER     2
#define CORE_PWM5_CHANNEL   B

#define CORE_PWM_COUNT      (6)

#endif


/*=============================================================================
  Pin definitions for the ATtiny1634
=============================================================================*/

#if defined( __AVR_ATtiny1634__ )

#define PIN_B0  ( 0)
#define PIN_A7  ( 1)
#define PIN_A6  ( 2)
#define PIN_A5  ( 3)
#define PIN_A4  ( 4)
#define PIN_A3  ( 5)
#define PIN_A2  ( 6)
#define PIN_A1  ( 7)
#define PIN_A0  ( 8)
#define PIN_C5  ( 9)
#define PIN_C4  (10)
#define PIN_C2  (11)
#define PIN_C1  (12)
#define PIN_C0  (13)
#define PIN_B3  (14)
#define PIN_B2  (15)
#define PIN_B1  (16)
#define PIN_C3  (17)  /* RESET */

#define PIN_PB0  ( 0)
#define PIN_PA7  ( 1)
#define PIN_PA6  ( 2)
#define PIN_PA5  ( 3)
#define PIN_PA4  ( 4)
#define PIN_PA3  ( 5)
#define PIN_PA2  ( 6)
#define PIN_PA1  ( 7)
#define PIN_PA0  ( 8)
#define PIN_PC5  ( 9)
#define PIN_PC4  (10)
#define PIN_PC2  (11)
#define PIN_PC1  (12)
#define PIN_PC0  (13)
#define PIN_PB3  (14)
#define PIN_PB2  (15)
#define PIN_PB1  (16)
#define PIN_PC3  (17)  /* RESET */

#define LED_BUILTIN (13)

#define CORE_DIGITAL_FIRST    (0)
#define CORE_DIGITAL_LAST     (17)
#define CORE_DIGITAL_COUNT    (CORE_DIGITAL_LAST-CORE_DIGITAL_FIRST+1)
#define CORE_RESET_INCLUDED   (1)

#define CORE_ANALOG_FIRST     (64)
#define CORE_ANALOG_COUNT     (13) // 12 + internal temperature sensor
#define CORE_ANALOG_LAST      (CORE_ANALOG_FIRST+CORE_ANALOG_COUNT-1)


#define NUM_DIGITAL_PINS            18
#define NUM_ANALOG_INPUTS           18

#define CORE_INT0_PIN  PIN_PC2

#define CORE_OC0A_PIN  PIN_PC0
#define CORE_OC0B_PIN  PIN_PA5
#define CORE_OC1A_PIN  PIN_PB3
#define CORE_OC1B_PIN  PIN_PA6

#define CORE_PWM0_PIN       CORE_OC0A_PIN
#define CORE_PWM0_TIMER     0
#define CORE_PWM0_CHANNEL   A

#define CORE_PWM1_PIN       CORE_OC0B_PIN
#define CORE_PWM1_TIMER     0
#define CORE_PWM1_CHANNEL   B

#define CORE_PWM2_PIN       CORE_OC1A_PIN
#define CORE_PWM2_TIMER     1
#define CORE_PWM2_CHANNEL   A

#define CORE_PWM3_PIN       CORE_OC1B_PIN
#define CORE_PWM3_TIMER     1
#define CORE_PWM3_CHANNEL   B

#define CORE_PWM_COUNT      (4)

#define digitalPinToInterrupt(p)  ((p) == 11 ? 0 : NOT_AN_INTERRUPT)

#endif

#if defined( __AVR_ATtiny828__ )

#define PIN_PA0  ( 0)
#define PIN_PA1  ( 1)
#define PIN_PA2  ( 2)
#define PIN_PA3  ( 3)
#define PIN_PA4  ( 4)
#define PIN_PA5  ( 5)
#define PIN_PA6  ( 6)
#define PIN_PA7  ( 7)
#define PIN_PB0  ( 8)
#define PIN_PB1  ( 9)
#define PIN_PB2  (10)
#define PIN_PB3  (11)
#define PIN_PB4  (12)
#define PIN_PB5  (13)
#define PIN_PB6  (14)
#define PIN_PB7  (15)
#define PIN_PC0  (16)
#define PIN_PC1  (17)
#define PIN_PC2  (18)
#define PIN_PC3  (19)
#define PIN_PC4  (20)
#define PIN_PC5  (21)
#define PIN_PC6  (22)
#define PIN_PC7  (23)
#define PIN_PD0  (24)
#define PIN_PD1  (25)
#define PIN_PD2  (26)  /* RESET */
#define PIN_PD3  (27)

#define PIN_A0  ( 0)
#define PIN_A1  ( 1)
#define PIN_A2  ( 2)
#define PIN_A3  ( 3)
#define PIN_A4  ( 4)
#define PIN_A5  ( 5)
#define PIN_A6  ( 6)
#define PIN_A7  ( 7)
#define PIN_B0  ( 8)
#define PIN_B1  ( 9)
#define PIN_B2  (10)
#define PIN_B3  (11)
#define PIN_B4  (12)
#define PIN_B5  (13)
#define PIN_B6  (14)
#define PIN_B7  (15)
#define PIN_C0  (16)
#define PIN_C1  (17)
#define PIN_C2  (18)
#define PIN_C3  (19)
#define PIN_C4  (20)
#define PIN_C5  (21)
#define PIN_C6  (22)
#define PIN_C7  (23)
#define PIN_D0  (24)
#define PIN_D1  (25)
#define PIN_D2  (26)  /* RESET */
#define PIN_D3  (27)

#define LED_BUILTIN (13)

#define CORE_DIGITAL_FIRST    (0)
#define CORE_DIGITAL_LAST     (28)
#define CORE_DIGITAL_COUNT    (CORE_DIGITAL_LAST-CORE_DIGITAL_FIRST+1)
#define CORE_RESET_INCLUDED   (1)

#define CORE_ANALOG_FIRST     (0)
#define CORE_ANALOG_COUNT     (28)
#define CORE_ANALOG_LAST      (CORE_ANALOG_FIRST+CORE_ANALOG_COUNT-1)

#define NUM_DIGITAL_PINS            28
#define NUM_ANALOG_INPUTS           28

#define CORE_INT0_PIN  PIN_PC1
#define CORE_INT1_PIN  PIN_PC2

#define CORE_OC0A_PIN  PIN_PC0
#define CORE_OC0B_PIN  PIN_PC4
#define CORE_OC1A_PIN  PIN_PC5
#define CORE_OC1B_PIN  PIN_PC6

#define CORE_PWM0_PIN       CORE_OC0A_PIN
#define CORE_PWM0_TIMER     0
#define CORE_PWM0_CHANNEL   A

#define CORE_PWM1_PIN       CORE_OC0B_PIN
#define CORE_PWM1_TIMER     0
#define CORE_PWM1_CHANNEL   B

#define CORE_PWM2_PIN       CORE_OC1A_PIN
#define CORE_PWM2_TIMER     1
#define CORE_PWM2_CHANNEL   A

#define CORE_PWM3_PIN       CORE_OC1B_PIN
#define CORE_PWM3_TIMER     1
#define CORE_PWM3_CHANNEL   B

#define CORE_PWM_COUNT      (4)

#define digitalPinToInterrupt(p)  ((p) == 17 ? 0 : ((p)==18?1: NOT_AN_INTERRUPT))

#endif
#endif
