;;; quail/cyrillic-tajik.el -- Quail package for inputting Tajik in Cyrillic -*- coding: utf-8 -*- 

;; Copyright (C) 1997 Electrotechnical Laboratory, JAPAN.
;; Licensed to the Free Software Foundation.
;; Copyright (C) 2007 Free Software Foundation.

;; Keywords: multilingual, input method, Cyrillic, Tajik

;; This file is part of XEmacs. 

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Code:

(require 'quail)

;; This file breaks with 21.4 and early 21.5. 
(unless (and (fboundp 'decode-char) (decode-char 'ucs #x31C)
	     (eq #x31C (encode-char (decode-char 'ucs #x31C) 'ucs)))
  (error 'unimplemented
         "Unicode support needed for this file not available!"))

;; Based on Valery Alexeev's cyrillic-translit. Aidan Kehoe, So Okt 7
;; 16:50:03 CEST 2007

(quail-define-package
 "cyrillic-tajik" "Cyrillic" "Жt" nil
 "Transliterated keyboard layout, with English consonant values.  For Tajik.

Russian alphabet: a b v=w g d e yo zh z i i' k l m n o p r s t
u f kh=x c ch sh shch=sj=/s=/sht ~ y ' e' yu ya

Tajik letters: 	gh = ғ, i- = ӣ, q = қ, u- = ӯ, h = ҳ, j = ҷ

Notes:
  for ц (TSE) use \"c\", never \"ts\"
  щ (SHCHA = Bulgarian SHT) = \"shch\", \"sj\", \"/sht\" or \"/t\",
  э (REVERSE ROUNDED E) = \"e'\" or \"e`\"
  х (KHA) when after с (S) = \"x\" or \"kh\"
  ъ (HARD SIGN) = \"~\", Ъ (CAPITAL HARD SIGN) = \"~~\",
  ь (SOFT SIGN) = \"'\", Ь (CAPITAL SOFT SIGN) = \"''\",
  я (YA) = \"ya\"

Also included are Ukrainian є (YE) = \"/e\" and ї (YI) = \"yi\", 
Belorussian ў (SHORT U) = \"u'\",
Serbian ђ (DJE) = \"/d\", ћ (CHJE)= \"/ch\", 
Macedonian ѓ (GJE) = \"/g\", ѕ (DZE) = \"/s\", ќ (KJE) = \"/k\",
cyrillic і (I DECIMAL) = \"/i\", ј (JE) = \"/j\", 
љ (LJE) = \"/l\", њ (NJE) = \"/n\" and џ (DZE) =\"/z\"."
 nil t t t t nil nil nil nil nil t)

(quail-define-rules
 ("a" ?а)    ;; U+0430 CYRILLIC SMALL LETTER A
 ("A" ?А)    ;; U+0410 CYRILLIC CAPITAL LETTER A
 ("b" ?б)    ;; U+0431 CYRILLIC SMALL LETTER BE
 ("B" ?Б)    ;; U+0411 CYRILLIC CAPITAL LETTER BE
 ("c" ?ц)    ;; U+0446 CYRILLIC SMALL LETTER TSE
 ("C" ?Ц)    ;; U+0426 CYRILLIC CAPITAL LETTER TSE
 ("ch" ?ч)   ;; U+0447 CYRILLIC SMALL LETTER CHE
 ("Ch" ?Ч)   ;; U+0427 CYRILLIC CAPITAL LETTER CHE
 ("CH" ?Ч)   ;; U+0427 CYRILLIC CAPITAL LETTER CHE
 ("/ch" ?ћ)  ;; U+045B CYRILLIC SMALL LETTER TSHE
 ("/Ch" ?Ћ)  ;; U+040B CYRILLIC CAPITAL LETTER TSHE
 ("/CH" ?Ћ)  ;; U+040B CYRILLIC CAPITAL LETTER TSHE
 ("d" ?д)    ;; U+0434 CYRILLIC SMALL LETTER DE
 ("D" ?Д)    ;; U+0414 CYRILLIC CAPITAL LETTER DE
 ("/d" ?ђ)   ;; U+0452 CYRILLIC SMALL LETTER DJE
 ("/D" ?Ђ)   ;; U+0402 CYRILLIC CAPITAL LETTER DJE
 ("e" ?е)    ;; U+0435 CYRILLIC SMALL LETTER IE
 ("E" ?Е)    ;; U+0415 CYRILLIC CAPITAL LETTER IE
 ("@" ?э)    ;; U+044D CYRILLIC SMALL LETTER E
 ("e'" ?э)   ;; U+044D CYRILLIC SMALL LETTER E
 ("E'" ?Э)   ;; U+042D CYRILLIC CAPITAL LETTER E
 ("e`" ?э)   ;; U+044D CYRILLIC SMALL LETTER E
 ("E`" ?Э)   ;; U+042D CYRILLIC CAPITAL LETTER E
 ("f" ?ф)    ;; U+0444 CYRILLIC SMALL LETTER EF
 ("F" ?Ф)    ;; U+0424 CYRILLIC CAPITAL LETTER EF
 ("g" ?г)    ;; U+0433 CYRILLIC SMALL LETTER GHE
 ("G" ?Г)    ;; U+0413 CYRILLIC CAPITAL LETTER GHE
 ("/e" ?є)   ;; U+0454 CYRILLIC SMALL LETTER UKRAINIAN IE
 ("/E" ?Є)   ;; U+0404 CYRILLIC CAPITAL LETTER UKRAINIAN IE
 ("/g" ?ѓ)   ;; U+0453 CYRILLIC SMALL LETTER GJE
 ("/G" ?Ѓ)   ;; U+0403 CYRILLIC CAPITAL LETTER GJE
 ("gh" ?ғ)   ;; U+0493 CYRILLIC SMALL LETTER GHE WITH STROKE
 ("Gh" ?Ғ)   ;; U+0492 CYRILLIC CAPITAL LETTER GHE WITH STROKE
 ("GH" ?Ғ)   ;; U+0492 CYRILLIC CAPITAL LETTER GHE WITH STROKE
 ("H" ?Ҳ)    ;; U+04B2 CYRILLIC CAPITAL LETTER HA WITH DESCENDER
 ("h" ?ҳ)    ;; U+04B3 CYRILLIC SMALL LETTER HA WITH DESCENDER
 ("i" ?и)    ;; U+0438 CYRILLIC SMALL LETTER I
 ("I" ?И)    ;; U+0418 CYRILLIC CAPITAL LETTER I
 ("i'" ?й)   ;; U+0439 CYRILLIC SMALL LETTER SHORT I
 ("I'" ?Й)   ;; U+0419 CYRILLIC CAPITAL LETTER SHORT I
 ("I-" ?Ӣ)   ;; U+04E2 CYRILLIC CAPITAL LETTER I WITH MACRON
 ("i-" ?ӣ)   ;; U+04E3 CYRILLIC SMALL LETTER I WITH MACRON
 ("i`" ?й)   ;; U+0439 CYRILLIC SMALL LETTER SHORT I
 ("I`" ?Й)   ;; U+0419 CYRILLIC CAPITAL LETTER SHORT I
 ("/i" ?і)   ;; U+0456 CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
 ("/I" ?І)   ;; U+0406 CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
 ("/j" ?ј)   ;; U+0458 CYRILLIC SMALL LETTER JE
 ("/J" ?Ј)   ;; U+0408 CYRILLIC CAPITAL LETTER JE
 ("J" ?Ҷ)    ;; U+04B6 CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
 ("j" ?ҷ)    ;; U+04B7 CYRILLIC SMALL LETTER CHE WITH DESCENDER
 ("JA" ?Я)   ;; U+042F CYRILLIC CAPITAL LETTER YA
 ("JO" ?Ё)   ;; U+0401 CYRILLIC CAPITAL LETTER IO
 ("JU" ?Ю)   ;; U+042E CYRILLIC CAPITAL LETTER YU
 ("k" ?к)    ;; U+043A CYRILLIC SMALL LETTER KA
 ("K" ?К)    ;; U+041A CYRILLIC CAPITAL LETTER KA
 ("/k" ?ќ)   ;; U+045C CYRILLIC SMALL LETTER KJE
 ("/K" ?Ќ)   ;; U+040C CYRILLIC CAPITAL LETTER KJE
 ("kh" ?х)   ;; U+0445 CYRILLIC SMALL LETTER HA
 ("Kh" ?Х)   ;; U+0425 CYRILLIC CAPITAL LETTER HA
 ("KH" ?Х)   ;; U+0425 CYRILLIC CAPITAL LETTER HA
 ("l" ?л)    ;; U+043B CYRILLIC SMALL LETTER EL
 ("L" ?Л)    ;; U+041B CYRILLIC CAPITAL LETTER EL
 ("/l" ?љ)   ;; U+0459 CYRILLIC SMALL LETTER LJE
 ("/L" ?Љ)   ;; U+0409 CYRILLIC CAPITAL LETTER LJE
 ("m" ?м)    ;; U+043C CYRILLIC SMALL LETTER EM
 ("M" ?М)    ;; U+041C CYRILLIC CAPITAL LETTER EM
 ("n" ?н)    ;; U+043D CYRILLIC SMALL LETTER EN
 ("N" ?Н)    ;; U+041D CYRILLIC CAPITAL LETTER EN
 ("/n" ?њ)   ;; U+045A CYRILLIC SMALL LETTER NJE
 ("/N" ?Њ)   ;; U+040A CYRILLIC CAPITAL LETTER NJE
 ("o" ?о)    ;; U+043E CYRILLIC SMALL LETTER O
 ("O" ?О)    ;; U+041E CYRILLIC CAPITAL LETTER O
 ("p" ?п)    ;; U+043F CYRILLIC SMALL LETTER PE
 ("P" ?П)    ;; U+041F CYRILLIC CAPITAL LETTER PE
 ("Q" ?Я)    ;; U+042F CYRILLIC CAPITAL LETTER YA
 ("Q" ?Қ)    ;; U+049A CYRILLIC CAPITAL LETTER KA WITH DESCENDER
 ("q" ?қ)    ;; U+049B CYRILLIC SMALL LETTER KA WITH DESCENDER
 ("r" ?р)    ;; U+0440 CYRILLIC SMALL LETTER ER
 ("R" ?Р)    ;; U+0420 CYRILLIC CAPITAL LETTER ER
 ("s" ?с)    ;; U+0441 CYRILLIC SMALL LETTER ES
 ("S" ?С)    ;; U+0421 CYRILLIC CAPITAL LETTER ES
 ("/s" ?ѕ)   ;; U+0455 CYRILLIC SMALL LETTER DZE
 ("/S" ?Ѕ)   ;; U+0405 CYRILLIC CAPITAL LETTER DZE
 ("sh" ?ш)   ;; U+0448 CYRILLIC SMALL LETTER SHA
 ("Sh" ?Ш)   ;; U+0428 CYRILLIC CAPITAL LETTER SHA
 ("SH" ?Ш)   ;; U+0428 CYRILLIC CAPITAL LETTER SHA
 ("shch" ?щ) ;; U+0449 CYRILLIC SMALL LETTER SHCHA
 ("Shch" ?Щ) ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("SHCH" ?Щ) ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("/sht" ?щ) ;; U+0449 CYRILLIC SMALL LETTER SHCHA
 ("/Sht" ?Щ) ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("/SHT" ?Щ) ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("sj" ?щ)   ;; U+0449 CYRILLIC SMALL LETTER SHCHA
 ("Sj" ?Щ)   ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("SJ" ?Щ)   ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("t" ?т)    ;; U+0442 CYRILLIC SMALL LETTER TE
 ("T" ?Т)    ;; U+0422 CYRILLIC CAPITAL LETTER TE
 ("/t" ?щ)   ;; U+0449 CYRILLIC SMALL LETTER SHCHA
 ("/T" ?Щ)   ;; U+0429 CYRILLIC CAPITAL LETTER SHCHA
 ("u" ?у)    ;; U+0443 CYRILLIC SMALL LETTER U
 ("U" ?У)    ;; U+0423 CYRILLIC CAPITAL LETTER U
 ("u'" ?ў)   ;; U+045E CYRILLIC SMALL LETTER SHORT U
 ("U'" ?Ў)   ;; U+040E CYRILLIC CAPITAL LETTER SHORT U
 ("U-" ?Ӯ)   ;; U+04EE CYRILLIC CAPITAL LETTER U WITH MACRON
 ("u-" ?ӯ)   ;; U+04EF CYRILLIC SMALL LETTER U WITH MACRON
 ("v" ?в)    ;; U+0432 CYRILLIC SMALL LETTER VE
 ("V" ?В)    ;; U+0412 CYRILLIC CAPITAL LETTER VE
 ("w" ?в)    ;; U+0432 CYRILLIC SMALL LETTER VE
 ("W" ?В)    ;; U+0412 CYRILLIC CAPITAL LETTER VE
 ("x" ?х)    ;; U+0445 CYRILLIC SMALL LETTER HA
 ("X" ?Х)    ;; U+0425 CYRILLIC CAPITAL LETTER HA
 ("y" ?ы)    ;; U+044B CYRILLIC SMALL LETTER YERU
 ("Y" ?Ы)    ;; U+042B CYRILLIC CAPITAL LETTER YERU
 ("ya" ?я)   ;; U+044F CYRILLIC SMALL LETTER YA
 ("Ya" ?Я)   ;; U+042F CYRILLIC CAPITAL LETTER YA
 ("YA" ?Я)   ;; U+042F CYRILLIC CAPITAL LETTER YA
 ("ye" ?е)   ;; U+0435 CYRILLIC SMALL LETTER IE
 ("Ye" ?Е)   ;; U+0415 CYRILLIC CAPITAL LETTER IE
 ("YE" ?Е)   ;; U+0415 CYRILLIC CAPITAL LETTER IE
 ("yi" ?ї)   ;; U+0457 CYRILLIC SMALL LETTER YI
 ("Yi" ?Ї)   ;; U+0407 CYRILLIC CAPITAL LETTER YI
 ("YI" ?Ї)   ;; U+0407 CYRILLIC CAPITAL LETTER YI
 ("yo" ?ё)   ;; U+0451 CYRILLIC SMALL LETTER IO
 ("Yo" ?Ё)   ;; U+0401 CYRILLIC CAPITAL LETTER IO
 ("YO" ?Ё)   ;; U+0401 CYRILLIC CAPITAL LETTER IO
 ("yu" ?ю)   ;; U+044E CYRILLIC SMALL LETTER YU
 ("Yu" ?Ю)   ;; U+042E CYRILLIC CAPITAL LETTER YU
 ("YU" ?Ю)   ;; U+042E CYRILLIC CAPITAL LETTER YU
 ("z" ?з)    ;; U+0437 CYRILLIC SMALL LETTER ZE
 ("Z" ?З)    ;; U+0417 CYRILLIC CAPITAL LETTER ZE
 ("/z" ?џ)   ;; U+045F CYRILLIC SMALL LETTER DZHE
 ("/Z" ?Џ)   ;; U+040F CYRILLIC CAPITAL LETTER DZHE
 ("zh" ?ж)   ;; U+0436 CYRILLIC SMALL LETTER ZHE
 ("Zh" ?Ж)   ;; U+0416 CYRILLIC CAPITAL LETTER ZHE
 ("ZH" ?Ж)   ;; U+0416 CYRILLIC CAPITAL LETTER ZHE
 ("~" ?ъ)    ;; U+044A CYRILLIC SMALL LETTER HARD SIGN
 ("~~" "Ъ")  ;; U+042A CYRILLIC CAPITAL LETTER HARD SIGN
 ("'" ?ь)    ;; U+044C CYRILLIC SMALL LETTER SOFT SIGN
 ("''" "Ь")  ;; U+042c CYRILLIC CAPITAL LETTER SOFT SIGN
 ("`" ?ь))    ;; U+044C CYRILLIC SMALL LETTER SOFT SIGN


 