/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.DocumentSwitcherTable;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener,
ListSelectionListener,
ComplexListDataListener,
PopupMenuListener {
    private static JPopupMenu popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private static ButtonPopupSwitcher currentSwitcher;
    private final DocumentSwitcherTable pTable;
    private final int x;
    private final int y;
    private boolean isDragging = true;
    private final Controller controller;

    public static void showPopup(JComponent jComponent, Controller controller, int n, int n2) {
        ButtonPopupSwitcher buttonPopupSwitcher = new ButtonPopupSwitcher(controller, n, n2);
        buttonPopupSwitcher.doSelect(jComponent);
        currentSwitcher = buttonPopupSwitcher;
    }

    private ButtonPopupSwitcher(Controller controller, int n, int n2) {
        this.controller = controller;
        SwitcherTableItem[] switcherTableItemArray = this.createSwitcherItems(controller);
        this.pTable = new DocumentSwitcherTable(controller, switcherTableItemArray, n2);
        this.x = n;
        this.y = n2;
    }

    private void doSelect(JComponent jComponent) {
        this.invokingComponent = jComponent;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        this.pTable.getSelectionModel().addListSelectionListener(this);
        this.controller.getTabModel().addComplexListDataListener((ComplexListDataListener)this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        popup = new JPopupMenu();
        popup.setBorderPainted(false);
        popup.setBorder(BorderFactory.createEmptyBorder());
        popup.add((Component)((Object)this.pTable));
        popup.pack();
        int n = this.x - (int)this.pTable.getPreferredSize().getWidth();
        int n2 = this.y + 1;
        popup.setLocation(n, n2);
        popup.setInvoker(this.invokingComponent);
        popup.addPopupMenuListener(this);
        popup.setVisible(true);
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    static void hidePopup() {
        if (ButtonPopupSwitcher.isShown()) {
            currentSwitcher.hideCurrentPopup();
        }
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        this.pTable.getSelectionModel().removeListSelectionListener(this);
        this.controller.getTabModel().removeComplexListDataListener((ComplexListDataListener)this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            popup.removePopupMenuListener(this);
            JPopupMenu jPopupMenu = popup;
            SwingUtilities.invokeLater(() -> {
                if (jPopupMenu.isVisible()) {
                    jPopupMenu.setVisible(false);
                }
            });
            popup.setVisible(false);
            popup = null;
            shown = false;
            currentSwitcher = null;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        DocumentSwitcherTable.Item item = this.pTable.getSelectedItem();
        StatusDisplayer.getDefault().setStatusText(null == item ? null : item.getDescription());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.changeSelection(mouseEvent);
        this.pTable.onMouseEvent(mouseEvent);
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.pTable.onMouseEvent(mouseEvent)) {
            this.hideCurrentPopup();
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        if (mouseEvent.getSource() == this.invokingComponent && (l = System.currentTimeMillis()) - this.invocationTime > 500L && this.isDragging) {
            this.mouseClicked(mouseEvent);
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        DocumentSwitcherTable.Item item;
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)((Object)this.pTable));
        if (this.pTable.contains(point) && !this.pTable.onMouseEvent(mouseEvent) && (item = this.pTable.getSelectedItem()) != null && !item.isSeparator()) {
            this.hideCurrentPopup();
            item.activate();
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.pTable.clearSelection();
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.changeSelection(mouseEvent);
        this.pTable.onMouseEvent(mouseEvent);
        mouseEvent.consume();
    }

    private void changeSelection(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() != this) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)((Object)this.pTable));
        }
        if (this.pTable.contains(point)) {
            int n = this.pTable.rowAtPoint(point);
            int n2 = this.pTable.columnAtPoint(point);
            this.pTable.changeSelection(n, n2, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() == this) {
            return;
        }
        if (aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
            if (!this.changeSelection((KeyEvent)aWTEvent)) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                this.hideCurrentPopup();
            } else {
                ((KeyEvent)aWTEvent).consume();
            }
        }
    }

    private boolean changeSelection(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.pTable.getSelectedRow();
        int n3 = this.pTable.getSelectedColumn();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        boolean bl = true;
        switch (n) {
            case 37: {
                if (--n3 >= 0) break;
                n3 = this.pTable.getColumnCount() - 1;
                break;
            }
            case 39: {
                if (++n3 <= this.pTable.getColumnCount() - 1) break;
                n3 = 0;
                break;
            }
            case 40: {
                if (++n2 <= this.pTable.getRowCount() - 1) break;
                n2 = 0;
                if (++n3 <= this.pTable.getColumnCount() - 1) break;
                n3 = 0;
                break;
            }
            case 38: {
                if (--n2 >= 0) break;
                n2 = this.pTable.getRowCount() - 1;
                if (--n3 >= 0) break;
                n3 = this.pTable.getColumnCount() - 1;
                break;
            }
            case 127: {
                DocumentSwitcherTable.Item item = this.pTable.getSelectedItem();
                if (item == null) break;
                TabData tabData = item.getTabData();
                int n4 = this.controller.getTabModel().indexOf(tabData);
                if (n4 >= 0) {
                    if (this.controller.getTabModel().size() == 1) {
                        SwingUtilities.invokeLater(this::hideCurrentPopup);
                    }
                    TabActionEvent tabActionEvent = new TabActionEvent((Object)this, "close", n4);
                    this.controller.postActionEvent(tabActionEvent);
                    n2 = Math.min(this.pTable.getModel().getRowCount() - 1, n2);
                    n3 = Math.min(this.pTable.getModel().getColumnCount() - 1, n3);
                    bl = true;
                    break;
                }
                if (!item.isSeparator() || !this.pTable.closeSelectedDocumentList()) break;
                SwingUtilities.invokeLater(this::hideCurrentPopup);
                break;
            }
            case 10: {
                DocumentSwitcherTable.Item item = this.pTable.getSelectedItem();
                if (item == null) break;
                item.activate();
                this.hideCurrentPopup();
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            this.pTable.changeSelection(n2, n3, false, false);
        }
        return bl;
    }

    private void changed() {
        if (!ButtonPopupSwitcher.isShown()) {
            return;
        }
        SwitcherTableItem[] switcherTableItemArray = this.createSwitcherItems(this.controller);
        if (switcherTableItemArray.length == 0) {
            this.hideCurrentPopup();
            return;
        }
        this.pTable.setSwitcherItems(switcherTableItemArray, this.y);
        popup.pack();
        int n = this.x - (int)this.pTable.getPreferredSize().getWidth();
        int n2 = this.y + 1;
        popup.setLocation(n, n2);
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.changed();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.changed();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.changed();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.changed();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (null != popup) {
            popup.removePopupMenuListener(this);
        }
        this.hideCurrentPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (null != popup) {
            popup.removePopupMenuListener(this);
        }
        this.hideCurrentPopup();
    }

    private DocumentSwitcherTable.Item[] createSwitcherItems(Controller controller) {
        Object object;
        Object object2;
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        boolean bl = Settings.getDefault().isSortDocumentListByProject() && projectSupport.isEnabled();
        List list = controller.getTabModel().getTabs();
        Map<Object, Object> map = Collections.emptyMap();
        if (bl && (map = projectSupport.tryGetProjectsForTabs(list)).isEmpty()) {
            bl = false;
        }
        ArrayList<DocumentSwitcherTable.Item> arrayList = new ArrayList<DocumentSwitcherTable.Item>(list.size());
        int n = controller.getSelectedIndex();
        TabData tabData = n >= 0 && n < controller.getTabModel().size() ? controller.getTabModel().getTab(n) : null;
        boolean bl2 = false;
        for (TabData tabData2 : list) {
            Object object3;
            if (tabData2.getComponent() instanceof TopComponent) {
                object3 = (TopComponent)tabData2.getComponent();
                object2 = object3.getDisplayName();
                if (object2 == null) {
                    object2 = object3.getName();
                }
                if ((object = object3.getHtmlDisplayName()) == null) {
                    object = object2;
                }
            } else {
                object2 = object = tabData2.getText();
            }
            object3 = null;
            if (bl) {
                object3 = (ProjectSupport.ProjectProxy)map.get(tabData2);
                bl2 |= null != object3;
            }
            arrayList.add(new DocumentSwitcherTable.Item(new ActivatableTab(tabData2), (String)object2, (String)object, tabData2, tabData2 == tabData, (ProjectSupport.ProjectProxy)object3));
        }
        Collections.sort(arrayList);
        if (bl && bl2) {
            Object object4 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (DocumentSwitcherTable.Item)((Object)arrayList.get(i));
                object = ((DocumentSwitcherTable.Item)((Object)object2)).getProject();
                if (null != object && !((ProjectSupport.ProjectProxy)object).equals(object4)) {
                    arrayList.add(i, DocumentSwitcherTable.Item.create((ProjectSupport.ProjectProxy)object));
                } else if (null == object && null != object4) {
                    arrayList.add(i, DocumentSwitcherTable.NO_PROJECT_SEPARATOR);
                }
                object4 = object;
            }
        }
        return arrayList.toArray(new DocumentSwitcherTable.Item[0]);
    }

    private class ActivatableTab
    implements SwitcherTableItem.Activatable {
        private final TabData tab;

        private ActivatableTab(TabData tabData) {
            this.tab = tabData;
        }

        public void activate() {
            if (this.tab != null) {
                this.selectTab(this.tab);
            }
        }

        private void selectTab(TabData tabData) {
            int n;
            List list = ButtonPopupSwitcher.this.controller.getTabModel().getTabs();
            int n2 = -1;
            for (n = 0; n < list.size(); ++n) {
                if (!tabData.equals(list.get(n))) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                n = ButtonPopupSwitcher.this.controller.getSelectedIndex();
                ButtonPopupSwitcher.this.controller.setSelectedIndex(n2);
            }
        }
    }
}

