/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.firestore.Watch;
import java.util.function.Function;
import java.util.logging.Logger;

final class SilenceableBidiStream<RequestT, ResponseT>
implements BidiStreamObserver<RequestT, ResponseT> {
    private final ClientStream<RequestT> stream;
    private final BidiStreamObserver<RequestT, ResponseT> delegate;
    private boolean silence = false;
    private static final Logger LOGGER = Logger.getLogger(Watch.class.getName());

    SilenceableBidiStream(BidiStreamObserver<RequestT, ResponseT> responseObserverT, Function<BidiStreamObserver<RequestT, ResponseT>, ClientStream<RequestT>> streamSupplier) {
        this.delegate = responseObserverT;
        this.stream = streamSupplier.apply(this);
    }

    public boolean isSilenced() {
        return this.silence;
    }

    public void send(RequestT request) {
        LOGGER.info(this.stream.toString());
        this.stream.send(request);
    }

    public void closeSend() {
        LOGGER.info(this.stream::toString);
        this.stream.closeSend();
    }

    public void closeSendAndSilence() {
        LOGGER.info(this.stream::toString);
        this.silence = true;
        this.stream.closeSend();
    }

    public void onReady(ClientStream<RequestT> stream) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", stream));
        } else {
            this.delegate.onReady(stream);
        }
    }

    public void onStart(StreamController controller) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onStart(controller);
        }
    }

    public void onResponse(ResponseT response) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onResponse(response);
        }
    }

    public void onError(Throwable t) {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onError(t);
        }
    }

    public void onComplete() {
        if (this.silence) {
            LOGGER.info(() -> String.format("Silenced: %s", this.stream));
        } else {
            this.delegate.onComplete();
        }
    }
}

