/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.base.Preconditions;
import io.grpc.alts.internal.BufUnwrapper;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;

public final class NettyTsiHandshaker {
    private BufUnwrapper unwrapper = new BufUnwrapper();
    private final TsiHandshaker internalHandshaker;

    public NettyTsiHandshaker(TsiHandshaker handshaker) {
        this.internalHandshaker = (TsiHandshaker)Preconditions.checkNotNull((Object)handshaker);
    }

    void getBytesToSendToPeer(ByteBuf out) throws GeneralSecurityException {
        Preconditions.checkState((this.unwrapper != null ? 1 : 0) != 0, (Object)"protector already created");
        try (BufUnwrapper unwrapper = this.unwrapper;){
            int bytesWritten = 0;
            for (ByteBuffer nioBuffer : unwrapper.writableNioBuffers(out)) {
                if (!nioBuffer.hasRemaining()) continue;
                int prevPos = nioBuffer.position();
                this.internalHandshaker.getBytesToSendToPeer(nioBuffer);
                bytesWritten += nioBuffer.position() - prevPos;
                if (nioBuffer.position() == prevPos) break;
            }
            out.writerIndex(out.writerIndex() + bytesWritten);
        }
    }

    boolean processBytesFromPeer(ByteBuf data) throws GeneralSecurityException {
        Preconditions.checkState((this.unwrapper != null ? 1 : 0) != 0, (Object)"protector already created");
        try (BufUnwrapper unwrapper = this.unwrapper;){
            int bytesRead = 0;
            boolean done = false;
            for (ByteBuffer nioBuffer : unwrapper.readableNioBuffers(data)) {
                if (!nioBuffer.hasRemaining()) continue;
                int prevPos = nioBuffer.position();
                done = this.internalHandshaker.processBytesFromPeer(nioBuffer);
                bytesRead += nioBuffer.position() - prevPos;
                if (done) break;
            }
            data.readerIndex(data.readerIndex() + bytesRead);
            boolean bl = done;
            return bl;
        }
    }

    boolean isInProgress() {
        return this.internalHandshaker.isInProgress();
    }

    TsiPeer extractPeer() throws GeneralSecurityException {
        Preconditions.checkState((!this.internalHandshaker.isInProgress() ? 1 : 0) != 0);
        return this.internalHandshaker.extractPeer();
    }

    Object extractPeerObject() throws GeneralSecurityException {
        Preconditions.checkState((!this.internalHandshaker.isInProgress() ? 1 : 0) != 0);
        return this.internalHandshaker.extractPeerObject();
    }

    TsiFrameProtector createFrameProtector(int maxFrameSize, ByteBufAllocator alloc) {
        this.unwrapper = null;
        return this.internalHandshaker.createFrameProtector(maxFrameSize, alloc);
    }

    TsiFrameProtector createFrameProtector(ByteBufAllocator alloc) {
        this.unwrapper = null;
        return this.internalHandshaker.createFrameProtector(alloc);
    }

    void close() {
        this.internalHandshaker.close();
    }
}

