/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.JEventListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JTextField;

class JEventListPanelDemo {
    private final EventList sillyObjects = new BasicEventList();

    JEventListPanelDemo() {
    }

    public void start() {
        this.sillyObjects.add("X 1");
        this.sillyObjects.add("X 3");
        this.sillyObjects.add("X 9");
        JEventListPanel panel = new JEventListPanel(this.sillyObjects, new SillyObjectFormat());
        panel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.RED));
        panel.setElementColumns(1);
        JButton addButton = new JButton("ADD");
        addButton.addActionListener(new AddAction(this.sillyObjects));
        JFrame frame = new JFrame("Silly Objects");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(panel, "North");
        frame.getContentPane().add((Component)addButton, "South");
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new JEventListPanelDemo().start();
    }

    static class AddAction
    implements ActionListener {
        private Random dice = new Random();
        private EventList target;

        public AddAction(EventList target) {
            this.target = target;
        }

        public void actionPerformed(ActionEvent e) {
            this.target.add(3, "X " + this.dice.nextInt(100));
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private String sillyObject;

        public ButtonActionListener(String sillyObject) {
            this.sillyObject = sillyObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEventListPanelDemo.this.sillyObjects.remove(this.sillyObject);
        }
    }

    public class SillyObjectFormat
    extends JEventListPanel.AbstractFormat {
        public SillyObjectFormat() {
            super("0dlu, pref, 0dlu, pref, 0dlu", "0dlu, pref, 0dlu, fill:pref:grow, 0dlu", "45dlu", "45dlu", new String[]{"2, 2, 1, 3", "4, 2", "4, 4"});
        }

        public int getComponentsPerElement() {
            return 3;
        }

        public JComponent getComponent(Object element, int component) {
            String sillyObject = (String)element;
            if (component == 0) {
                JButton button = new JButton(sillyObject);
                button.addActionListener(new ButtonActionListener(sillyObject));
                return button;
            }
            if (component == 1) {
                return new JSlider();
            }
            if (component == 2) {
                return new JTextField();
            }
            throw new IllegalStateException();
        }
    }
}

