"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceEndpoints = exports.SEARCH_API = exports.QUERY_NUMBER_TWO = exports.QUERY_NUMBER_ONE = exports.PLUGIN_NAME = exports.PLUGIN_ID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'searchRelevance';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'Search Relevance';
let ServiceEndpoints = exports.ServiceEndpoints = /*#__PURE__*/function (ServiceEndpoints) {
  ServiceEndpoints["GetIndexes"] = "/api/relevancy/search/indexes";
  ServiceEndpoints["GetPipelines"] = "/api/relevancy/search/pipelines";
  ServiceEndpoints["GetSearchResults"] = "/api/relevancy/search";
  ServiceEndpoints["GetStats"] = "/api/relevancy/stats";
  return ServiceEndpoints;
}({});
const SEARCH_API = exports.SEARCH_API = '/_search';

//Query1 for the left search and Query2 for the right search page
const QUERY_NUMBER_ONE = exports.QUERY_NUMBER_ONE = '1';
const QUERY_NUMBER_TWO = exports.QUERY_NUMBER_TWO = '2';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJQTFVHSU5fSUQiLCJleHBvcnRzIiwiUExVR0lOX05BTUUiLCJTZXJ2aWNlRW5kcG9pbnRzIiwiU0VBUkNIX0FQSSIsIlFVRVJZX05VTUJFUl9PTkUiLCJRVUVSWV9OVU1CRVJfVFdPIl0sInNvdXJjZXMiOlsiaW5kZXgudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5leHBvcnQgY29uc3QgUExVR0lOX0lEID0gJ3NlYXJjaFJlbGV2YW5jZSc7XG5leHBvcnQgY29uc3QgUExVR0lOX05BTUUgPSAnU2VhcmNoIFJlbGV2YW5jZSc7XG5cbmV4cG9ydCBlbnVtIFNlcnZpY2VFbmRwb2ludHMge1xuICBHZXRJbmRleGVzID0gJy9hcGkvcmVsZXZhbmN5L3NlYXJjaC9pbmRleGVzJyxcbiAgR2V0UGlwZWxpbmVzID0gJy9hcGkvcmVsZXZhbmN5L3NlYXJjaC9waXBlbGluZXMnLFxuICBHZXRTZWFyY2hSZXN1bHRzID0gJy9hcGkvcmVsZXZhbmN5L3NlYXJjaCcsXG4gIEdldFN0YXRzID0gJy9hcGkvcmVsZXZhbmN5L3N0YXRzJyxcbn1cblxuZXhwb3J0IGNvbnN0IFNFQVJDSF9BUEkgPSAnL19zZWFyY2gnO1xuXG4vL1F1ZXJ5MSBmb3IgdGhlIGxlZnQgc2VhcmNoIGFuZCBRdWVyeTIgZm9yIHRoZSByaWdodCBzZWFyY2ggcGFnZVxuZXhwb3J0IGNvbnN0IFFVRVJZX05VTUJFUl9PTkUgPSAnMSc7XG5leHBvcnQgY29uc3QgUVVFUllfTlVNQkVSX1RXTyA9ICcyJztcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRU8sTUFBTUEsU0FBUyxHQUFBQyxPQUFBLENBQUFELFNBQUEsR0FBRyxpQkFBaUI7QUFDbkMsTUFBTUUsV0FBVyxHQUFBRCxPQUFBLENBQUFDLFdBQUEsR0FBRyxrQkFBa0I7QUFBQyxJQUVsQ0MsZ0JBQWdCLEdBQUFGLE9BQUEsQ0FBQUUsZ0JBQUEsMEJBQWhCQSxnQkFBZ0I7RUFBaEJBLGdCQUFnQjtFQUFoQkEsZ0JBQWdCO0VBQWhCQSxnQkFBZ0I7RUFBaEJBLGdCQUFnQjtFQUFBLE9BQWhCQSxnQkFBZ0I7QUFBQTtBQU9yQixNQUFNQyxVQUFVLEdBQUFILE9BQUEsQ0FBQUcsVUFBQSxHQUFHLFVBQVU7O0FBRXBDO0FBQ08sTUFBTUMsZ0JBQWdCLEdBQUFKLE9BQUEsQ0FBQUksZ0JBQUEsR0FBRyxHQUFHO0FBQzVCLE1BQU1DLGdCQUFnQixHQUFBTCxPQUFBLENBQUFLLGdCQUFBLEdBQUcsR0FBRyJ9