/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class EntityJavaType<T>
extends AbstractClassJavaType<T> {
    public EntityJavaType(Class<T> type, MutabilityPlan<T> mutabilityPlan) {
        super(type, mutabilityPlan, IncomparableComparator.INSTANCE);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        throw new JdbcTypeRecommendationException("Could not determine recommended JdbcType for `" + ((Class)this.getJavaType()).getTypeName() + "`");
    }

    @Override
    public int extractHashCode(T value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(T one, T another) {
        return one == another;
    }

    @Override
    public boolean isInstance(Object value) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(value);
        Class javaTypeClass = this.getJavaTypeClass();
        if (lazyInitializer != null) {
            return javaTypeClass.isAssignableFrom(lazyInitializer.getPersistentClass()) || javaTypeClass.isAssignableFrom(lazyInitializer.getImplementationClass());
        }
        return javaTypeClass.isAssignableFrom(value.getClass());
    }

    @Override
    public String toString(T value) {
        return value.toString();
    }

    @Override
    public T fromString(CharSequence string) {
        throw new UnsupportedOperationException("Conversion from String strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        throw new UnsupportedOperationException("Unwrap strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        throw new UnsupportedOperationException("Wrap strategy not known for this Java type : " + ((Class)this.getJavaType()).getTypeName());
    }

    public String toString() {
        return "EntityJavaType(" + ((Class)this.getJavaType()).getTypeName() + ")";
    }
}

