/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root;

import org.glassfish.jersey.server.ResourceConfig;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rest.Health;
import org.jitsi.rest.Version;
import org.jitsi.rest.prometheus.Prometheus;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.RestConfig;
import org.jitsi.videobridge.rest.binders.ServiceBinder;
import org.jitsi.videobridge.rest.filters.ConfigFilter;
import org.jitsi.videobridge.xmpp.XmppConnection;

public class Application
extends ResourceConfig {
    public Application(Videobridge videobridge, XmppConnection xmppConnection, @NotNull org.jitsi.utils.version.Version version, @NotNull JvbHealthChecker healthChecker2) {
        this.register(new ServiceBinder(videobridge, xmppConnection, healthChecker2));
        this.register((Class)ConfigFilter.class);
        this.packages("org.jitsi.videobridge.rest.root");
        if (RestConfig.config.isEnabled(RestApis.HEALTH)) {
            this.register(new Health(healthChecker2));
        }
        if (RestConfig.config.isEnabled(RestApis.VERSION)) {
            this.register(new Version(version));
        }
        if (RestConfig.config.isEnabled(RestApis.PROMETHEUS)) {
            this.register(new Prometheus(VideobridgeMetricsContainer.getInstance()));
        }
    }
}

