/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ms extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "Albania";
        final String metaValue_AM = "Armenia";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_BY = "Belarus";
        final String metaValue_DE = "Jerman";
        final String metaValue_DK = "Denmark";
        final String metaValue_EE = "Estonia";
        final String metaValue_ES = "Sepanyol";
        final String metaValue_ET = "Ethiopia";
        final String metaValue_FI = "Finland";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Perancis";
        final String metaValue_GE = "Georgia";
        final String metaValue_HR = "Croatia";
        final String metaValue_HT = "Haiti";
        final String metaValue_HU = "Hungary";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IE = "Ireland";
        final String metaValue_IS = "Iceland";
        final String metaValue_IT = "Itali";
        final String metaValue_JP = "Jepun";
        final String metaValue_KI = "Kiribati";
        final String metaValue_KZ = "Kazakhstan";
        final String metaValue_LA = "Laos";
        final String metaValue_LT = "Lithuania";
        final String metaValue_LU = "Luxembourg";
        final String metaValue_LV = "Latvia";
        final String metaValue_MK = "Macedonia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norway";
        final String metaValue_NP = "Nepal";
        final String metaValue_NR = "Nauru";
        final String metaValue_PH = "Filipina";
        final String metaValue_PL = "Poland";
        final String metaValue_RO = "Romania";
        final String metaValue_RS = "Serbia";
        final String metaValue_RU = "Rusia";
        final String metaValue_SE = "Sweden";
        final String metaValue_SI = "Slovenia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_UA = "Ukraine";
        final String metaValue_UZ = "Uzbekistan";
        final String metaValue_VN = "Vietnam";
        final String metaValue_WS = "Samoa";
        final String metaValue_ar = "Arab";
        final String metaValue_bn = "Benggala";
        final String metaValue_bo = "Tibet";
        final String metaValue_el = "Greek";
        final String metaValue_he = "Ibrani";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_ban = "Bali";
        final Object[][] data = new Object[][] {
            { "ksh", "Colognian" },
            { "mwl", "Mirandese" },
            { "Zsym", "Simbol" },
            { "type.nu.lanatham", "Digit Tai Tham Tham" },
            { "Zsye", "Emoji" },
            { "tem", "Timne" },
            { "type.nu.sind", "Digit Khudawadi" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "AC", "Pulau Ascension" },
            { "rar", "Rarotonga" },
            { "tet", "Tetum" },
            { "type.nu.sinh", "Digit Sinhala Lith" },
            { "AD", "Andorra" },
            { "AE", "Emiriah Arab Bersatu" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua dan Barbuda" },
            { "type.nu.mroo", "Digit Mro" },
            { "type.ca.ethiopic", "Kalendar Ethiopia" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Zon Waktu" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "AS", "Samoa Amerika" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "Inggeris AS" },
            { "AX", "Kepulauan Aland" },
            { "mye", "Myene" },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia dan Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Caribbean" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalendar Parsi" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "CA", "Kanada" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Pulau Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curacao" },
            { "CX", "Pulau Krismas" },
            { "CY", "Cyprus" },
            { "type.nu.bali", "Digit Bali" },
            { "CZ", "Czechia" },
            { "eka", "Ekajuk" },
            { "DE", metaValue_DE },
            { "ace", "Aceh" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Digit Devanagari" },
            { "DJ", "Djibouti" },
            { "DK", metaValue_DK },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Angka Kecil Armenia" },
            { "DO", "Republik Dominica" },
            { "gor", "Gorontalo" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "DZ", "Algeria" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Ke Kelebaran Separa" },
            { "EA", "Ceuta dan Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", metaValue_EE },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "pau", "Palauan" },
            { "chk", "Chukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "Digit Matematik Tebal" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "Kesatuan Eropah" },
            { "type.ca.gregorian", "Kalendar Gregory" },
            { "EZ", "Zon Euro" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "ady", "Adyghe" },
            { "aeb", "Arab Tunisia" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Micronesia" },
            { "key.va", "Varian Tempat" },
            { "FO", "Kepulauan Faroe" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "root", "Root" },
            { "type.ca.indian", "Kalendar Kebangsaan India" },
            { "grc", "Greek Purba" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "pcm", "Nigerian Pidgin" },
            { "GD", "Grenada" },
            { "GE", metaValue_GE },
            { "GF", "Guiana Perancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Khatulistiwa" },
            { "GR", "Greece" },
            { "GS", "Kepulauan Georgia Selatan & Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "type.nu.mathmono", "Digit Matematik Monospace" },
            { "GW", "Guinea Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ckb", "Kurdi Sorani" },
            { "zxx", "Tiada kandungan linguistik" },
            { "tly", "Talysh" },
            { "de_AT", "Jerman Austria" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kepulauan Heard & McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman Switzerland" },
            { "type.ca.islamic-umalqura", "Kalendar Islam (Umm Al-Quran)" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "Kepulauan Canary" },
            { "nan", "Cina Min Nan" },
            { "ID", metaValue_ID },
            { "type.nu.kali", "Digit Kayah Li" },
            { "IE", metaValue_IE },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "type.nu.sora", "Digit Sora Sompeng" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "Peraturan Isihan Eropah" },
            { "IO", "Wilayah Lautan Hindi British" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "Zmth", "Tatatanda matematik" },
            { "type.nu.thai", "Digit Thai" },
            { "%%POSIX", "Komputer" },
            { "type.nu.beng", "Digit Benggali" },
            { "type.nu.cyrl", "Digit Cyril" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendar Islam" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", metaValue_JP },
            { "ain", "Ainu" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Digit Kannada" },
            { "de_CH", "Jerman Halus Switzerland" },
            { "type.co.phonetic", "Urutan Isih Fonetik" },
            { "type.ca.buddhist", "Kalendar Buddha" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kemboja" },
            { "KI", metaValue_KI },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts dan Nevis" },
            { "fr_CA", "Perancis Kanada" },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "fr_CH", "Perancis Switzerland" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kepulauan Cayman" },
            { "KZ", metaValue_KZ },
            { "Cyrl", "Cyril" },
            { "LA", metaValue_LA },
            { "LB", "Lubnan" },
            { "LC", "Saint Lucia" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Jerman Rendah" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "cop", "Coptic" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maghribi" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Kepulauan Marshall" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Digit Vai" },
            { "MK", metaValue_MK },
            { "type.nu.mathdbl", "Digit Matematik Dwilejang" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "new", "Newari" },
            { "MO", "Macau SAR China" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", metaValue_MT },
            { "type.m0.ungegn", "Transliterasi UN GEGN" },
            { "MU", "Mauritius" },
            { "alt", "Altai Selatan" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kalendar Jepun" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "Afrika Sub-Sahara" },
            { "type.ca.hebrew", "Kalendar Ibrani" },
            { "type.co.dictionary", "Aturan Isih Kamus" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Pulau Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "NZ", "New Zealand" },
            { "crh", "Turki Krimea" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Perancis Seselwa Creole" },
            { "type.nu.hmng", "Digit Pahawh Hmong" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalendar Sivil Islam" },
            { "en_GB", "Inggeris British" },
            { "PE", "Peru" },
            { "PF", "Polinesia Perancis" },
            { "PG", "Papua New Guinea" },
            { "PH", metaValue_PH },
            { "PK", "Pakistan" },
            { "PL", metaValue_PL },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Wilayah Palestin" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Angka Huruf Kecil Greek" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "niu", "Niu" },
            { "QO", "Oceania Terpencil" },
            { "lez", "Lezghian" },
            { "type.nu.ahom", "Digit Ahom" },
            { "type.nu.takr", "Digit Takri" },
            { "tvl", metaValue_TV },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "RE", "Reunion" },
            { "005", "Amerika Selatan" },
            { "jbo", "Lojban" },
            { "009", "Oceania" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "type.nu.talu", "Digit Tai Lue Baru" },
            { "SA", "Arab Saudi" },
            { "SB", "Kepulauan Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Barat" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", metaValue_SE },
            { "013", "Amerika Tengah" },
            { "014", "Afrika Timur" },
            { "015", "Afrika Utara" },
            { "SG", "Singapura" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "Gaya Pemisah Baris Ketat" },
            { "SI", metaValue_SI },
            { "017", "Afrika Tengah" },
            { "type.nu.mymrtlng", "Digit Myanmar Tai Laing" },
            { "018", "Selatan Afrika" },
            { "SJ", "Svalbard dan Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "Bamu", "Bamu" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "SR", "Surinam" },
            { "SS", "Sudan Selatan" },
            { "ST", "Sao Tome dan Principe" },
            { "arq", "Arab Algeria" },
            { "SV", "El Salvador" },
            { "ars", "Arab Najdi" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "arz", "Arab Mesir" },
            { "ary", "Arab Maghribi" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistem Ukuran AS" },
            { "021", "Utara Amerika" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "yav", "Yangben" },
            { "TD", "Chad" },
            { "TF", "Wilayah Selatan Perancis" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "029", "Caribbean" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Cari Mengikut Konsonan Awal Hangul" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Trinidad dan Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturia" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Tulisan Tidak Diketahui" },
            { "UA", metaValue_UA },
            { "rup", "Aromanian" },
            { "030", "Asia Timur" },
            { "tyv", "Tuvinian" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Asia Selatan" },
            { "035", "Asia Tenggara" },
            { "UG", "Uganda" },
            { "hak", "Cina Hakka" },
            { "type.co.pinyin", "Aturan Isih Pinyin" },
            { "039", "Eropah Selatan" },
            { "Sinh", metaValue_si },
            { "UM", "Kepulauan Terpencil A.S." },
            { "UN", "Bangsa-bangsa Bersatu" },
            { "US", "Amerika Syarikat" },
            { "haw", "Hawaii" },
            { "type.co.gb2312han", "Aturan Isih Bahasa Cina Ringkas - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prusia" },
            { "UZ", metaValue_UZ },
            { "tzm", "Tamazight Atlas Tengah" },
            { "type.co.stroke", "Aturan Isih Coretan" },
            { "nnh", "Ngiemboon" },
            { "VA", "Kota Vatican" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Kepulauan Virgin British" },
            { "VI", "Kepulauan Virgin A.S." },
            { "VN", metaValue_VN },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis dan Futuna" },
            { "type.co.traditional", "Aturan Isih Tradisional" },
            { "057", "Wilayah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Angka Kewangan" },
            { "type.co.compat", "Tertib Isihan Sebelumnya" },
            { "wae", "Walser" },
            { "WS", metaValue_WS },
            { "type.nu.mtei", "Digit Meetei Mayek" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polinesia" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Digit Brahmi" },
            { "Gujr", "Gujarat" },
            { "Zxxx", "Tidak ditulis" },
            { "wbp", "Warlpiri" },
            { "YE", "Yaman" },
            { "nqo", "N\u2019ko" },
            { "type.co.standard", "Tertib Isih Standard" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Digit Cham" },
            { "ZA", "Afrika Selatan" },
            { "type.nu.sund", "Digit Sunda" },
            { "type.lb.loose", "Gaya Pemisah Baris Bebas" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Angka Georgia" },
            { "type.co.zhuyin", "Aturan Isih Zhuyin" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wilayah Tidak Diketahui" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.iso8601", "Kalendar ISO-8601" },
            { "nso", "Sotho Utara" },
            { "type.nu.telu", "Digit Telugu" },
            { "lou", "Kreol Louisiana" },
            { "loz", "Lozi" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Angka Kewangan Cina Ringkas" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Digit Indi Arab Lanjutan" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Digit Lebar Penuh" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Luri Utara" },
            { "type.co.emoji", "Aturan Isih Emoji" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Kalendar Islam (Arab Saudi, cerapan)" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Angka Roman" },
            { "sah", "Sakha" },
            { "type.nu.shrd", "Digit Sharada" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "type.d0.npinyin", "Bernombor" },
            { "type.nu.native", "Digit Asal" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "type.nu.tirh", "Digit Tirhuta" },
            { "type.d0.fwidth", "Ke Kelebaran Penuh" },
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "fil", metaValue_PH },
            { "hmn", "Hmong" },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "type.nu.wara", "Digit Warang Citi" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "es_ES", "Sepanyol Eropah" },
            { "sco", "Scots" },
            { "scn", "Sicili" },
            { "aa", "Afar" },
            { "ab", "Abkhazia" },
            { "ae", "Avestan" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Digit Chakma" },
            { "bbj", "Ghomala" },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "an", "Aragon" },
            { "Jpan", metaValue_JP },
            { "ar", metaValue_ar },
            { "Hrkt", "Ejaan sukuan Jepun" },
            { "as", "Assam" },
            { "av", "Avaric" },
            { "sdh", "Kurdish Selatan" },
            { "ay", "Aymara" },
            { "az", metaValue_AZ },
            { "ba", "Bashkir" },
            { "type.co.unihan", "Aturan Isih Coretan Radikal" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "Bislama" },
            { "type.nu.java", "Digit Jawa" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "see", "Seneca" },
            { "Mymr", "Myammar" },
            { "type.nu.laoo", "Digit Lao" },
            { "seh", "Sena" },
            { "ca", "Catalonia" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsica" },
            { "Orya", "Oriya" },
            { "cs", "Czech" },
            { "cu", "Slavik Gereja" },
            { "cv", "Chuvash" },
            { "cy", "Wales" },
            { "type.nu.ethi", "Angka Ethiopia" },
            { "da", metaValue_DK },
            { "pt_PT", "Portugis Eropah" },
            { "de", metaValue_DE },
            { "type.cf.standard", "Format Mata Wang Standard" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Digit Mongolia" },
            { "dv", "Divehi" },
            { "es_419", "Sepanyol Amerika Latin" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendar Cina" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Angka Greek" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Gaya Pemisah Baris Biasa" },
            { "ro_MD", "Moldavia" },
            { "el", metaValue_el },
            { "en", "Inggeris" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Aturan Isih Cina Tradisional - Big5" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "Hanb", "Han dengan Bopomofo" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbian Atas" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "fa", "Parsi" },
            { "Hans", "Ringkas" },
            { "type.nu.latn", "Digit Barat" },
            { "Hant", "Tradisional" },
            { "ff", "Fulah" },
            { "shu", "Arab Chadian" },
            { "hsn", "Cina Xiang" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fon", "Fon" },
            { "bgn", "Balochi Barat" },
            { "yue", "Kantonis" },
            { "fo", "Faroe" },
            { "type.m0.bgn", "Transliterasi BGN AS" },
            { "umb", "Umbundu" },
            { "fr", metaValue_FR },
            { "fy", "Frisian Barat" },
            { "ga", metaValue_IE },
            { "gd", "Scots Gaelic" },
            { "gl", "Galicia" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Bahasa Tidak Diketahui" },
            { "type.ca.ethiopic-amete-alem", "Kalendar Amete Alem Ethiopia" },
            { "gu", "Gujerat" },
            { "type.ca.islamic-tbla", "Kalendar Islam (jadual, zaman astronomi)" },
            { "gv", "Manx" },
            { "type.nu.osma", "Digit Osmanya" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bin", "Bini" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "Herero" },
            { "frc", "Perancis Cajun" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "Digit Tibet" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "doi", "Dogri" },
            { "type.nu.lepc", "Digit Lepcha" },
            { "bkm", "Kom" },
            { "sma", "Sami Selatan" },
            { "jv", "Jawa" },
            { "mad", "Madura" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_GE },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Cina Wu" },
            { "sms", "Skolt Sami" },
            { "kg", "Kongo" },
            { "ki", "Kikuya" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", metaValue_KZ },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmir" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "Digit Malayalam" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "Sistem Ukuran Imperial" },
            { "type.nu.lana", "Digit Tai Tham Hora" },
            { "lt", metaValue_LT },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Malagasy" },
            { "mh", "Marshall" },
            { "type.co.ducet", "Tertib Isih Unikod Lalai" },
            { "mi", "Maori" },
            { "mk", metaValue_MK },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", "Burma" },
            { "Armn", metaValue_AM },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Sorbian Rendah" },
            { "na", metaValue_NR },
            { "type.co.search", "Carian Tujuan Umum" },
            { "nb", "Bokm\u00e5l Norway" },
            { "nd", "Ndebele Utara" },
            { "ne", metaValue_NP },
            { "ng", "Ndonga" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norway" },
            { "no", metaValue_NO },
            { "nr", "Ndebele Selatan" },
            { "type.nu.modi", "Digit Modi" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "oc", "Occitania" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "type.nu.armn", "Angka Armenia" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossete" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardia" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "kbl", "Kanembu" },
            { "pl", metaValue_PL },
            { "type.nu.saur", "Digit Saurashtra" },
            { "type.ca.dangi", "Kalendar Dangi" },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "key.co", "Tertib Isihan" },
            { "pt_BR", "Portugis Brazil" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Format Mata wang" },
            { "type.nu.nkoo", "Digit N\u2019Ko" },
            { "key.ca", "Kalendar" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "ssy", "Saho" },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Digit Myammar" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_ET },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Mata wang" },
            { "ro", metaValue_RO },
            { "type.nu.orya", "Digit Oriya" },
            { "type.nu.hanidec", "Angka Perpuluhan Cina" },
            { "ru", metaValue_RU },
            { "bss", "Akoose" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Inggeris Australia" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinia" },
            { "sd", "Sindhi" },
            { "se", "Sami Utara" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "SerboCroatia" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Digit Indi-Arab" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "Swati" },
            { "type.cf.account", "Format Mata Wang Perakaunan" },
            { "st", "Sotho Selatan" },
            { "su", "Sunda" },
            { "sv", metaValue_SE },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Angka Kewangan Cina Tradisional" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "Buriat" },
            { "143", "Asia Tengah" },
            { "te", metaValue_te },
            { "145", "Asia Barat" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "bug", "Bugis" },
            { "kfo", "Koro" },
            { "en_CA", "Inggeris Kanada" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Angka Jepun" },
            { "tr", metaValue_TR },
            { "ts", "Tsonga" },
            { "swb", "Comoria" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "150", "Eropah" },
            { "151", "Eropah Timur" },
            { "type.nu.mathsanb", "Digit Matematik San Serif Tebal" },
            { "154", "Eropah Utara" },
            { "dzg", "Dazaga" },
            { "155", "Eropah Barat" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Lazim" },
            { "uk", metaValue_UA },
            { "type.ca.coptic", "Kalendar Qibti" },
            { "ur", "Urdu" },
            { "xal", "Kalmyk" },
            { "uz", metaValue_UZ },
            { "kha", "Khasi" },
            { "nds_NL", "Saxon Rendah" },
            { "ve", "Venda" },
            { "type.ca.roc", "Kalendar Minguo" },
            { "vi", metaValue_VN },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Kitaran Jam (12 berbanding 24)" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "type.nu.mathsans", "Digit Matematik San Serif" },
            { "quc", "K\u02bciche\u02bc" },
            { "type.nu.gonm", "Digit Masaram Gondi" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", "Syriac" },
            { "Grek", metaValue_el },
            { "gan", "Cina Gan" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Maghribi Standard" },
            { "ar_001", "Arab Standard Moden" },
            { "Cans", "Cans" },
            { "Mong", metaValue_MN },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Angka Cina Ringkas" },
            { "type.nu.hant", "Angka Cina Tradisional" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Angka Huruf Kecil Roman" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "es_MX", "Sepanyol Mexico" },
            { "vai", "Vai" },
            { "kln", "Kalenjin" },
            { "zh", "Cina" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Aturan Isih Buku Telefon" },
            { "Geor", metaValue_GE },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Angka Kewangan Jepun" },
            { "gez", "Geez" },
            { "type.nu.mymrshan", "Digit Myanmar Shan" },
            { "type.nu.olck", "Digit Ol Chiki" },
            { "type.co.reformed", "Aturan Isih Pembaharuan" },
            { "ebu", "Embu" },
            { "zh_Hans", "Cina Ringkas" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "type.nu.limb", "Digit Limbu" },
            { "zh_Hant", "Cina Tradisional" },
            { "kpe", "Kpelle" },
            { "type.nu.khmr", "Digit Khmer" },
            { "ilo", "Iloko" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "mul", "Pelbagai Bahasa" },
            { "key.ms", "Sistem Ukuran" },
            { "mus", "Creek" },
            { "gil", metaValue_KI },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krl", "Karelian" },
            { "efi", "Efik" },
            { "key.nu", "Nombor" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
