/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class ListOption<T>
extends AbstractOption<List<AbstractOption<T>>> {
    private static final Logger logger = Logger.getLogger(ListOption.class.getName());
    private AbstractOption<T> template;
    private int maximumNumber = Integer.MAX_VALUE;
    private final List<AbstractOption<T>> value = new ArrayList<AbstractOption<T>>();
    protected boolean allowDuplicates = true;
    private static final String MAXIMUM_NUMBER_TAG = "maximumNumber";
    private static final String TEMPLATE_TAG = "template";

    public ListOption(Specification specification) {
        super(specification);
    }

    public ListOption(String id, Specification specification) {
        super(id, specification);
    }

    public AbstractOption<T> getTemplate() {
        return this.template;
    }

    public void setTemplate(AbstractOption<T> template) {
        this.template = template;
    }

    public int getMaximumNumber() {
        return this.maximumNumber;
    }

    public void setMaximumNumber(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    public List<T> getOptionValues() {
        return CollectionUtils.transform(this.value, CollectionUtils.isNotNull(), AbstractOption::getValue);
    }

    private void addMember(AbstractOption<T> ao) {
        if (this.canAdd(ao)) {
            this.value.add(ao);
        }
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean canAdd(AbstractOption<T> ao) {
        return this.allowDuplicates ? true : CollectionUtils.none(this.value, CollectionUtils.matchKey(ao));
    }

    protected void setListValues(ListOption<T> lo) {
        this.setMaximumNumber(lo.getMaximumNumber());
        this.setTemplate(lo.getTemplate());
        this.setAllowDuplicates(lo.getAllowDuplicates());
    }

    @Override
    public List<AbstractOption<T>> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<AbstractOption<T>> value) {
        if (value == null) {
            throw new RuntimeException("Null ListOption: " + this);
        }
        ArrayList<AbstractOption<T>> oldValue = new ArrayList<AbstractOption<T>>(this.value);
        this.value.clear();
        for (AbstractOption<T> op : value) {
            this.addMember(op);
        }
        if (this.isDefined && !value.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(MAXIMUM_NUMBER_TAG, this.maximumNumber);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.template != null) {
            xw.writeStartElement(TEMPLATE_TAG);
            this.template.toXML(xw);
            xw.writeEndElement();
        }
        for (AbstractOption<T> option : this.value) {
            option.toXML(xw);
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maximumNumber = xr.getAttribute(MAXIMUM_NUMBER_TAG, 1);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.value.clear();
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag;
        switch (tag = xr.getLocalName()) {
            case "template": {
                xr.nextTag();
                this.template = this.readChildOption(xr);
                xr.closeTag(TEMPLATE_TAG);
                break;
            }
            default: {
                try {
                    AbstractOption<T> op = this.readChildOption(xr);
                    if (op == null) break;
                    this.addMember(op);
                    break;
                }
                catch (XMLStreamException xse) {
                    logger.log(Level.WARNING, "Invalid option at: " + tag, xse);
                    xr.closeTag(tag);
                }
            }
        }
    }

    private AbstractOption<T> readChildOption(FreeColXMLReader xr) throws XMLStreamException {
        return this.readOption(xr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId());
        if (this.value != null) {
            sb.append(" [");
            for (AbstractOption<T> ao : this.value) {
                sb.append(' ').append(ao);
            }
            sb.append(" ]");
        }
        if (this.template != null) {
            sb.append(" template=").append(this.template);
        }
        sb.append(']');
        return sb.toString();
    }
}

