/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.util.CollectionUtils;

public final class Market
extends FreeColGameObject
implements Ownable {
    private static final Logger logger = Logger.getLogger(Market.class.getName());
    public static final String TAG = "market";
    public static final int MINIMUM_AMOUNT = 100;
    public static final String PRICE_CHANGE = "priceChange";
    private final Map<GoodsType, MarketData> marketData = new HashMap<GoodsType, MarketData>();
    private Player owner;
    private final ArrayList<TransactionListener> transactionListeners = new ArrayList();
    private static final String OWNER_TAG = "owner";

    public Market(Game game, Player player) {
        super(game);
        this.owner = player;
        for (GoodsType goodsType : this.getSpecification().getStorableGoodsTypeList()) {
            this.putMarketData(goodsType, new MarketData(game, goodsType));
        }
    }

    public Market(Game game, String id) {
        super(game, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<GoodsType, MarketData> getMarketData() {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            return this.marketData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MarketData> getMarketDataValues() {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            return this.marketData.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketData getMarketData(GoodsType goodsType) {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            return this.marketData.get(goodsType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMarketData(GoodsType goodsType, MarketData data) {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            this.marketData.put(goodsType, data);
        }
    }

    private MarketData requireMarketData(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(this.getGame(), goodsType);
            this.putMarketData(goodsType, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarketData(Map<GoodsType, MarketData> data) {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            this.marketData.clear();
            this.marketData.putAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMarketData() {
        Map<GoodsType, MarketData> map = this.marketData;
        synchronized (map) {
            this.marketData.clear();
        }
    }

    public boolean hasBeenTraded(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data != null && data.getTraded();
    }

    public int getCostToBuy(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : data.getCostToBuy();
    }

    public int getPaidForSale(GoodsType type) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : data.getPaidForSale();
    }

    public boolean addGoodsToMarket(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setAmountInMarket(Math.max(100, data.getAmountInMarket() + amount));
        data.setTraded(true);
        return data.price();
    }

    public int getInitialPrice(GoodsType goodsType) {
        MarketData data = this.requireMarketData(goodsType);
        return data.getInitialPrice();
    }

    public void setInitialPrice(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setInitialPrice(amount);
    }

    public int getBidPrice(GoodsType type, int amount) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : amount * data.getCostToBuy();
    }

    public int getSalePrice(GoodsType type, int amount) {
        MarketData data = this.getMarketData(type);
        return data == null ? 0 : amount * data.getPaidForSale();
    }

    public <T extends AbstractGoods> int getSalePrice(T goods) {
        return this.getSalePrice(goods.getType(), goods.getAmount());
    }

    public int getArrears(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getArrears();
    }

    public void setArrears(GoodsType goodsType, int value) {
        MarketData data = this.requireMarketData(goodsType);
        data.setArrears(value);
    }

    public int getSales(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getSales();
    }

    public void modifySales(GoodsType goodsType, int amount) {
        if (amount != 0) {
            MarketData data = this.requireMarketData(goodsType);
            data.setSales(data.getSales() + amount);
            data.setTraded(true);
        }
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getIncomeBeforeTaxes();
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setIncomeBeforeTaxes(data.getIncomeBeforeTaxes() + amount);
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getIncomeAfterTaxes();
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.requireMarketData(goodsType);
        data.setIncomeAfterTaxes(data.getIncomeAfterTaxes() + amount);
    }

    public int getAmountInMarket(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data == null ? 0 : data.getAmountInMarket();
    }

    public boolean hasPriceChanged(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        return data != null && data.getOldPrice() != 0 && data.getOldPrice() != data.getCostToBuy();
    }

    public void flushPriceChange(GoodsType goodsType) {
        MarketData data = this.getMarketData(goodsType);
        if (data != null) {
            data.setOldPrice(data.getCostToBuy());
        }
    }

    public ModelMessage makePriceChangeMessage(GoodsType goodsType) {
        int newPrice;
        MarketData data = this.getMarketData(goodsType);
        int oldPrice = data.getOldPrice();
        return oldPrice == (newPrice = data.getCostToBuy()) ? null : (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.MARKET_PRICES, newPrice > oldPrice ? "model.market.priceIncrease" : "model.market.priceDecrease", this, goodsType).addStringTemplate("%market%", this.owner.getMarketName())).addNamed("%goods%", goodsType)).addAmount("%buy%", newPrice)).addAmount("%sell%", data.getPaidForSale());
    }

    public void update(GoodsType goodsType) {
        MarketData data = this.requireMarketData(goodsType);
        data.update();
    }

    public <T extends AbstractGoods> Comparator<T> getSalePriceComparator() {
        return Comparator.comparingInt(t -> this.getSalePrice(t.getType(), t.getAmount())).reversed();
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    public TransactionListener[] getTransactionListener() {
        return this.transactionListeners.toArray(new TransactionListener[0]);
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        this.owner = owner;
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return player == this.getOwner() ? this.getOwner().getEurope() : null;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Market o = this.copyInCast(other, Market.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.marketData.clear();
        for (MarketData md : game.update(o.getMarketDataValues(), true)) {
            this.marketData.put(md.getGoodsType(), md);
        }
        this.owner = game.updateRef(o.getOwner());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OWNER_TAG, this.owner);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.owner)) {
            for (MarketData data : CollectionUtils.sort(this.getMarketDataValues())) {
                data.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.owner = xr.findFreeColGameObject(this.getGame(), OWNER_TAG, Player.class, null, true);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearMarketData();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if ("marketData".equals(tag)) {
            MarketData data = xr.readFreeColObject(this.getGame(), MarketData.class);
            this.putMarketData(data.getGoodsType(), data);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId()).append(" owner=").append(this.owner == null ? "null" : this.owner.getId());
        for (MarketData md : CollectionUtils.sort(this.getMarketDataValues())) {
            sb.append(' ').append(md);
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum Access {
        EUROPE,
        CUSTOM_HOUSE;

    }
}

