/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransDependency
implements XMLInterface,
Cloneable {
    public static final String XML_TAG = "dependency";
    private DatabaseMeta db;
    private String tablename;
    private String fieldname;
    private long id;

    public TransDependency(DatabaseMeta db, String tablename, String fieldname) {
        this.db = db;
        this.tablename = tablename;
        this.fieldname = fieldname;
    }

    public TransDependency() {
        this(null, null, null);
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)(this.db == null ? "" : this.db.getName())));
        xml.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.fieldname));
        xml.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public TransDependency(Node depnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            String depcon = XMLHandler.getTagValue((Node)depnode, (String)"connection");
            this.db = DatabaseMeta.findDatabase(databases, (String)depcon);
            this.tablename = XMLHandler.getTagValue((Node)depnode, (String)"table");
            this.fieldname = XMLHandler.getTagValue((Node)depnode, (String)"field");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("TransDependency.Exception.UnableToLoadTransformation"), (Throwable)e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public void setDatabase(DatabaseMeta db) {
        this.db = db;
    }

    public DatabaseMeta getDatabase() {
        return this.db;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public TransDependency(Repository rep, long id_dependency, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.setID(id_dependency);
            RowMetaAndData r = rep.getTransDependency(id_dependency);
            if (r != null) {
                long id_connection = r.getInteger("ID_DATABASE", 0L);
                this.db = DatabaseMeta.findDatabase(databases, (long)id_connection);
                this.tablename = r.getString("TABLE_NAME", null);
                this.fieldname = r.getString("FIELD_NAME", null);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("TransDependency.Exception.UnableToLoadTransformationDependency") + id_dependency, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws KettleException {
        try {
            long id_database = this.db == null ? -1L : this.db.getID();
            this.setID(rep.insertDependency(id_transformation, id_database, this.tablename, this.fieldname));
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("TransDependency.Exception.UnableToSaveTransformationDepency") + id_transformation, (Throwable)dbe);
        }
    }
}

