/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRStringUtil {
    public static String replaceCRwithLF(String text) {
        if (text != null) {
            int length = text.length();
            char[] chars = text.toCharArray();
            int r = 0;
            boolean dirty = false;
            for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                if (ch == '\r') {
                    dirty = true;
                    if (i + 1 < length && chars[i + 1] == '\n') {
                        ++r;
                        continue;
                    }
                    chars[i - r] = 10;
                    continue;
                }
                chars[i - r] = ch;
            }
            return dirty ? new String(chars, 0, length - r) : text;
        }
        return null;
    }

    public static String xmlEncode(String text) {
        int length = text.length();
        if (text != null && length > 0) {
            StringBuffer ret = new StringBuffer(length * 12 / 10);
            int last = 0;
            block7: for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '&': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&amp;");
                        continue block7;
                    }
                    case '>': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&gt;");
                        continue block7;
                    }
                    case '<': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&lt;");
                        continue block7;
                    }
                    case '\"': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&apos;");
                        continue block7;
                    }
                }
            }
            if (last < length) {
                ret.append(text.substring(last));
            }
            return ret.toString();
        }
        return text;
    }

    public static String htmlEncode(String text) {
        int length = text.length();
        if (text != null && length > 0) {
            StringBuffer ret = new StringBuffer(length * 12 / 10);
            boolean isEncodeSpace = true;
            int last = 0;
            block8: for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        if (isEncodeSpace) {
                            if (last < i) {
                                ret.append(text.substring(last, i));
                            }
                            last = i + 1;
                            ret.append("&nbsp;");
                            isEncodeSpace = false;
                            continue block8;
                        }
                        isEncodeSpace = true;
                        continue block8;
                    }
                    case '&': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&amp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '>': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&gt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '<': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&lt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\"': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&quot;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\n': {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("<br/>");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    default: {
                        isEncodeSpace = false;
                    }
                }
            }
            if (last < length) {
                ret.append(text.substring(last));
            }
            return ret.toString();
        }
        return text;
    }

    public static String getLiteral(String name) {
        if (JRStringUtil.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }
}

