/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    public static final double NORMAL = 0.0;
    public static final double INVERTED = Math.PI;
    public static final double VERTICAL_LEFT = 4.71238898038469;
    public static final double VERTICAL_RIGHT = 1.5707963267948966;
    private double textRotation = 0.0;
    private boolean painting = false;
    private Painter foregroundPainter;
    private Painter backgroundPainter;
    private boolean multiLine;
    private int pWidth;
    private int pHeight;
    private boolean dontIgnoreRepaint = false;
    private int occupiedWidth;
    private static final String oldRendererKey = "washtml";
    private boolean paintBorderInsets = true;
    private int maxLineSpan = -1;
    public boolean painted;

    public JXLabel() {
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image) {
        super(image);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text) {
        super(text);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter<JXLabel>(){

            @Override
            protected void doPaint(Graphics2D g, JXLabel label, int width, int height) {
                Insets i = JXLabel.this.getInsets();
                g = (Graphics2D)g.create(-i.left, -i.top, width, height);
                label.paint(g);
                g.dispose();
            }

            @Override
            protected boolean shouldUseCache() {
                return false;
            }
        };
    }

    private void initLineWrapSupport() {
        this.addPropertyChangeListener(new MultiLineSupport());
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent e) {
                View view;
                Rectangle viewportBounds;
                if (e.getChanged() instanceof JViewport && (viewportBounds = e.getChanged().getBounds()).getWidth() < (double)JXLabel.this.getWidth() && (view = JXLabel.this.getWrappingView()) != null) {
                    view.setSize(viewportBounds.width, viewportBounds.height);
                }
            }
        });
    }

    public final Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    public void reshape(int x, int y, int w, int h) {
        View view;
        int oldH = this.getHeight();
        super.reshape(x, y, w, h);
        if (!this.isLineWrap()) {
            return;
        }
        if (oldH == 0) {
            return;
        }
        if (w > this.getVisibleRect().width) {
            w = this.getVisibleRect().width;
        }
        if ((view = (View)this.getClientProperty("html")) != null && view instanceof Renderer) {
            Insets i = this.getInsets();
            int dx = i.left + i.right;
            Rectangle iconR = this.calculateIconRect();
            view.setSize(w - this.occupiedWidth, h);
        }
    }

    public void setForegroundPainter(Painter painter) {
        Painter old = this.getForegroundPainter();
        this.foregroundPainter = painter;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public final Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public double getTextRotation() {
        return this.textRotation;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return size;
        }
        if (this.textRotation == 0.0) {
            int gap;
            View view = this.getWrappingView();
            if (view == null) {
                if (this.isLineWrap() && !MultiLineSupport.isHTML(this.getText())) {
                    this.getMultiLineSupport();
                    this.putClientProperty("html", MultiLineSupport.createView(this));
                    view = (View)this.getClientProperty("html");
                } else {
                    return size;
                }
            }
            Insets insets = this.getInsets();
            int dx = insets.left + insets.right;
            int dy = insets.top + insets.bottom;
            Rectangle textR = new Rectangle();
            Rectangle viewR = new Rectangle();
            textR.height = 0;
            textR.width = 0;
            textR.y = 0;
            textR.x = 0;
            viewR.x = dx;
            viewR.y = dy;
            viewR.height = Short.MAX_VALUE;
            viewR.width = Short.MAX_VALUE;
            Rectangle iconR = this.calculateIconRect();
            boolean textIsEmpty = this.getText() == null || this.getText().equals("");
            int lsb = 0;
            if (textIsEmpty) {
                textR.height = 0;
                textR.width = 0;
                gap = 0;
            } else {
                JPanel panel;
                Border b;
                gap = iconR.width == 0 ? 0 : this.getIconTextGap();
                this.occupiedWidth = dx + iconR.width + gap;
                Container parent = this.getParent();
                if (parent != null && parent instanceof JPanel && (b = (panel = (JPanel)parent).getBorder()) != null) {
                    Insets in = b.getBorderInsets(panel);
                    this.occupiedWidth += in.left + in.right;
                }
                int availTextWidth = this.getHorizontalTextPosition() == 0 ? viewR.width : viewR.width - (iconR.width + gap);
                float xPrefSpan = view.getPreferredSpan(0);
                textR.width = Math.min(availTextWidth, (int)xPrefSpan);
                if (this.maxLineSpan > 0) {
                    textR.width = Math.min(textR.width, this.maxLineSpan);
                    if (xPrefSpan > (float)this.maxLineSpan) {
                        view.setSize(this.maxLineSpan, textR.height);
                    }
                }
                textR.height = (int)view.getPreferredSpan(1);
                if (textR.height == 0) {
                    textR.height = this.getFont().getSize();
                }
            }
            textR.y = this.getVerticalTextPosition() == 1 ? (this.getHorizontalTextPosition() != 0 ? 0 : -(textR.height + gap)) : (this.getVerticalTextPosition() == 0 ? iconR.height / 2 - textR.height / 2 : (this.getVerticalTextPosition() != 0 ? iconR.height - textR.height : iconR.height + gap));
            textR.x = this.getHorizontalTextPosition() == 2 ? -(textR.width + gap) : (this.getHorizontalTextPosition() == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
            int labelR_x = Math.min(iconR.x, textR.x);
            int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
            int labelR_y = Math.min(iconR.y, textR.y);
            int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
            int day = this.getVerticalAlignment() == 1 ? viewR.y - labelR_y : (this.getVerticalAlignment() == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
            int dax = this.getHorizontalAlignment() == 2 ? viewR.x - labelR_x : (this.getHorizontalAlignment() == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
            textR.x += dax;
            textR.y += day;
            iconR.x += dax;
            iconR.y += day;
            if (lsb < 0) {
                textR.x -= lsb;
            }
            int x1 = Math.min(iconR.x, textR.x);
            int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
            int y1 = Math.min(iconR.y, textR.y);
            int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
            Dimension rv = new Dimension(x2 - x1, y2 - y1);
            rv.width += dx;
            rv.height += dy;
            return rv;
        }
        double theta = this.getTextRotation();
        size.setSize(JXLabel.rotateWidth(size, theta), JXLabel.rotateHeight(size, theta));
        return size;
    }

    private View getWrappingView() {
        if (super.getTopLevelAncestor() == null) {
            return null;
        }
        View view = (View)this.getClientProperty("html");
        if (!(view instanceof Renderer)) {
            return null;
        }
        return view;
    }

    private Container getViewport() {
        for (Container p = this; p != null; p = p.getParent()) {
            if (!(p instanceof Window) && !(p instanceof Applet) && !(p instanceof JViewport)) continue;
            return p;
        }
        return null;
    }

    private Rectangle calculateIconRect() {
        Rectangle iconR = new Rectangle();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        return iconR;
    }

    public int getMaxLineSpan() {
        return this.maxLineSpan;
    }

    public void setMaxLineSpan(int maxLineSpan) {
        int old = this.getMaxLineSpan();
        this.maxLineSpan = maxLineSpan;
        this.firePropertyChange("maxLineSpan", old, this.getMaxLineSpan());
    }

    private static int rotateWidth(Dimension size, double theta) {
        return (int)Math.round((double)size.width * Math.abs(Math.cos(theta)) + (double)size.height * Math.abs(Math.sin(theta)));
    }

    private static int rotateHeight(Dimension size, double theta) {
        return (int)Math.round((double)size.width * Math.abs(Math.sin(theta)) + (double)size.height * Math.abs(Math.cos(theta)));
    }

    public void setTextRotation(double textOrientation) {
        double old = this.getTextRotation();
        this.textRotation = textOrientation;
        if (old != this.getTextRotation()) {
            this.firePropertyChange("textRotation", old, this.getTextRotation());
        }
        this.repaint();
    }

    public void setLineWrap(boolean b) {
        boolean old = this.isLineWrap();
        this.multiLine = b;
        if (this.isLineWrap() != old) {
            this.firePropertyChange("lineWrap", old, this.isLineWrap());
            if (this.getForegroundPainter() != null) {
                ((AbstractPainter)this.getForegroundPainter()).setCacheable(!b);
            }
        }
    }

    public boolean isLineWrap() {
        return this.multiLine;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public boolean isOpaque() {
        return this.painting ? false : super.isOpaque();
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    protected void paintComponent(Graphics g) {
        this.painted = true;
        if (this.painting || this.backgroundPainter == null && this.foregroundPainter == null) {
            super.paintComponent(g);
        } else {
            this.pWidth = this.getWidth();
            this.pHeight = this.getHeight();
            Insets i = this.getInsets();
            if (this.backgroundPainter != null) {
                Graphics2D tmp = (Graphics2D)g.create();
                if (!this.isPaintBorderInsets()) {
                    tmp.translate(i.left, i.top);
                    this.pWidth = this.pWidth - i.left - i.right;
                    this.pHeight = this.pHeight - i.top - i.bottom;
                }
                this.backgroundPainter.paint(tmp, this, this.pWidth, this.pHeight);
                tmp.dispose();
            }
            if (this.foregroundPainter != null) {
                this.pWidth = this.getWidth() - i.left - i.right;
                this.pHeight = this.getHeight() - i.top - i.bottom;
                Point2D tPoint = this.calculateT();
                double wx = Math.sin(this.textRotation) * tPoint.getY() + Math.cos(this.textRotation) * tPoint.getX();
                double wy = Math.sin(this.textRotation) * tPoint.getX() + Math.cos(this.textRotation) * tPoint.getY();
                double x = ((double)this.getWidth() - wx) / 2.0 + Math.sin(this.textRotation) * tPoint.getY();
                double y = ((double)this.getHeight() - wy) / 2.0;
                Graphics2D tmp = (Graphics2D)g.create();
                if (i != null) {
                    tmp.translate((double)i.left + x, (double)i.top + y);
                } else {
                    tmp.translate(x, y);
                }
                tmp.rotate(this.textRotation);
                this.painting = true;
                this.foregroundPainter.paint(tmp, this, this.pWidth, this.pHeight);
                tmp.dispose();
                this.painting = false;
                this.pWidth = 0;
                this.pHeight = 0;
            }
        }
    }

    private Point2D calculateT() {
        double tx = this.getWidth();
        double ty = this.getHeight();
        if (this.textRotation > 4.697 && this.textRotation < 4.727 || this.textRotation > 1.555 && this.textRotation < 1.585) {
            int tmp = this.pHeight;
            this.pHeight = this.pWidth;
            this.pWidth = tmp;
            tx = this.pWidth;
            ty = this.pHeight;
        } else if (this.textRotation > -0.015 && this.textRotation < 0.015 || this.textRotation > 3.14 && this.textRotation < 3.143) {
            this.pHeight = this.getHeight();
            this.pWidth = this.getWidth();
        } else {
            this.dontIgnoreRepaint = false;
            double square = (double)Math.min(this.getHeight(), this.getWidth()) * Math.cos(0.7853981633974483);
            View v = (View)this.getClientProperty("html");
            if (v == null) {
                ty = this.getFontMetrics(this.getFont()).getHeight();
                double cw = ((double)this.getWidth() - Math.abs(ty * Math.sin(this.textRotation))) / Math.abs(Math.cos(this.textRotation));
                double ch = ((double)this.getHeight() - Math.abs(ty * Math.cos(this.textRotation))) / Math.abs(Math.sin(this.textRotation));
                tx = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
            } else {
                float w = v.getPreferredSpan(0);
                float h = v.getPreferredSpan(1);
                double c = w;
                double alpha = this.textRotation;
                boolean ready = false;
                while (!ready) {
                    while (h == v.getPreferredSpan(1)) {
                        v.setSize(w -= 10.0f, h);
                    }
                    if ((double)w < square || (double)h > square) {
                        w = h = (float)square;
                        v.setSize(w, 100000.0f);
                        break;
                    }
                    h = v.getPreferredSpan(1);
                    double cw = ((double)this.getWidth() - Math.abs((double)h * Math.sin(alpha))) / Math.abs(Math.cos(alpha));
                    double ch = ((double)this.getHeight() - Math.abs((double)h * Math.cos(alpha))) / Math.abs(Math.sin(alpha));
                    c = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
                    if ((c -= 1.0) > (double)w) {
                        v.setSize((float)c, 10.0f * h);
                        ready = true;
                        continue;
                    }
                    v.setSize((float)c, 10.0f * h);
                    if (v.getPreferredSpan(1) > h) {
                        v.setSize(w, 10.0f * h);
                        continue;
                    }
                    w = (float)c;
                    ready = true;
                }
                tx = Math.floor(w);
                ty = h;
            }
            this.pWidth = (int)tx;
            this.pHeight = (int)ty;
            this.dontIgnoreRepaint = true;
        }
        return new Point2D.Double(tx, ty);
    }

    public void repaint() {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(x, y, width, height);
    }

    public void repaint(long tm) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(tm);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(tm, x, y, width, height);
    }

    public int getHeight() {
        int retValue = super.getHeight();
        if (this.painting) {
            retValue = this.pHeight;
        }
        return retValue;
    }

    public int getWidth() {
        int retValue = super.getWidth();
        if (this.painting) {
            retValue = this.pWidth;
        }
        return retValue;
    }

    protected MultiLineSupport getMultiLineSupport() {
        return new MultiLineSupport();
    }

    protected int getOccupiedWidth() {
        return this.occupiedWidth;
    }

    static class StateInvariantError
    extends Error {
        public StateInvariantError(String s) {
            super(s);
        }
    }

    static class AlterBoxView
    extends BoxView {
        Rectangle tempRect;
        boolean majorAllocValid;
        SizeRequirements minorRequest;

        public AlterBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        protected short getRightInset() {
            return super.getRightInset();
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (!this.isAllocationValid()) {
                Rectangle alloc = a.getBounds();
                this.setSize(alloc.width, alloc.height);
            }
            return super.viewToModel(x, y, a, bias);
        }
    }

    static class SegmentCache {
        private static SegmentCache sharedCache = new SegmentCache();
        private List<Segment> segments = new ArrayList<Segment>(11);

        public static SegmentCache getSharedInstance() {
            return sharedCache;
        }

        public static Segment getSharedSegment() {
            return SegmentCache.getSharedInstance().getSegment();
        }

        public static void releaseSharedSegment(Segment segment) {
            SegmentCache.getSharedInstance().releaseSegment(segment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment getSegment() {
            SegmentCache segmentCache = this;
            synchronized (segmentCache) {
                int size = this.segments.size();
                if (size > 0) {
                    return this.segments.remove(size - 1);
                }
            }
            return new CachedSegment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSegment(Segment segment) {
            if (segment instanceof CachedSegment) {
                SegmentCache segmentCache = this;
                synchronized (segmentCache) {
                    segment.array = null;
                    segment.count = 0;
                    this.segments.add(segment);
                }
            }
        }

        private static class CachedSegment
        extends Segment {
            private CachedSegment() {
            }
        }
    }

    static class AlterGlyphView
    extends GlyphView
    implements TabableView,
    Cloneable {
        private JustificationInfo justificationInfo = null;

        public AlterGlyphView(Element elem) {
            super(elem);
        }

        JustificationInfo getJustificationInfo(int rowStartOffset) {
            if (this.justificationInfo != null) {
                return this.justificationInfo;
            }
            boolean TRAILING = false;
            boolean CONTENT = true;
            int SPACES = 2;
            int startOffset = this.getStartOffset();
            int endOffset = this.getEndOffset();
            Segment segment = this.getText(startOffset, endOffset);
            int txtOffset = segment.offset;
            int txtEnd = segment.offset + segment.count - 1;
            int startContentPosition = txtEnd + 1;
            int endContentPosition = txtOffset - 1;
            int trailingSpaces = 0;
            int contentSpaces = 0;
            int leadingSpaces = 0;
            boolean hasTab = false;
            BitSet spaceMap = new BitSet(endOffset - startOffset + 1);
            int state = 0;
            for (int i = txtEnd; i >= txtOffset; --i) {
                if (' ' == segment.array[i]) {
                    spaceMap.set(i - txtOffset);
                    if (state == 0) {
                        ++trailingSpaces;
                        continue;
                    }
                    if (state == 1) {
                        state = 2;
                        leadingSpaces = 1;
                        continue;
                    }
                    if (state != 2) continue;
                    ++leadingSpaces;
                    continue;
                }
                if ('\t' == segment.array[i]) {
                    hasTab = true;
                    break;
                }
                if (state == 0) {
                    if ('\n' != segment.array[i] && '\r' != segment.array[i]) {
                        state = 1;
                        endContentPosition = i;
                    }
                } else if (state != 1 && state == 2) {
                    contentSpaces += leadingSpaces;
                    leadingSpaces = 0;
                }
                startContentPosition = i;
            }
            SegmentCache.releaseSharedSegment(segment);
            int startJustifiableContent = -1;
            if (startContentPosition < txtEnd) {
                startJustifiableContent = startContentPosition - txtOffset;
            }
            int endJustifiableContent = -1;
            if (endContentPosition > txtOffset) {
                endJustifiableContent = endContentPosition - txtOffset;
            }
            this.justificationInfo = new JustificationInfo(startJustifiableContent, endJustifiableContent, leadingSpaces, contentSpaces, trailingSpaces, hasTab, spaceMap);
            return this.justificationInfo;
        }

        static class JustificationInfo {
            final int start;
            final int end;
            final int leadingSpaces;
            final int contentSpaces;
            final int trailingSpaces;
            final boolean hasTab;
            final BitSet spaceMap;

            JustificationInfo(int start, int end, int leadingSpaces, int contentSpaces, int trailingSpaces, boolean hasTab, BitSet spaceMap) {
                this.start = start;
                this.end = end;
                this.leadingSpaces = leadingSpaces;
                this.contentSpaces = contentSpaces;
                this.trailingSpaces = trailingSpaces;
                this.hasTab = hasTab;
                this.spaceMap = spaceMap;
            }
        }
    }

    class Row
    extends AlterBoxView {
        private int justification;
        private float lineSpacing;
        protected int firstLineIndent;
        static final int SPACE_ADDON = 0;
        static final int SPACE_ADDON_LEFTOVER_END = 1;
        static final int START_JUSTIFIABLE = 2;
        static final int END_JUSTIFIABLE = 3;
        int[] justificationData;

        Row(Element elem) {
            super(elem, 0);
            this.firstLineIndent = 0;
            this.justificationData = null;
        }

        protected void loadChildren(ViewFactory f) {
        }

        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        public float getAlignment(int axis) {
            if (axis == 0) {
                switch (this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                    case 3: {
                        float rv = 0.5f;
                        if (this.isJustifiableDocument()) {
                            rv = 0.0f;
                        }
                        return rv;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                return super.modelToView(pos, a, b);
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            r = loc.getBounds();
            r.height = height;
            r.y = y;
            return r;
        }

        public int getStartOffset() {
            int offs = Integer.MAX_VALUE;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.min(offs, v.getStartOffset());
            }
            return offs;
        }

        public int getEndOffset() {
            int offs = 0;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.max(offs, v.getEndOffset());
            }
            return offs;
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        private boolean isLastRow() {
            View parent = this.getParent();
            return parent == null || this == parent.getView(parent.getViewCount() - 1);
        }

        private boolean isBrokenRow() {
            View lastView;
            boolean rv = false;
            int viewsCount = this.getViewCount();
            if (viewsCount > 0 && (lastView = this.getView(viewsCount - 1)).getBreakWeight(0, 0.0f, 0.0f) >= 3000) {
                rv = true;
            }
            return rv;
        }

        private boolean isJustifiableDocument() {
            return !Boolean.TRUE.equals(this.getDocument().getProperty("i18n"));
        }

        private boolean isJustifyEnabled() {
            boolean ret = this.justification == 3;
            ret = ret && this.isJustifiableDocument();
            ret = ret && !this.isLastRow();
            ret = ret && !this.isBrokenRow();
            return ret;
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            SizeRequirements ret = super.calculateMajorAxisRequirements(axis, r);
            if (this.isJustifyEnabled()) {
                this.justificationData = oldJustficationData;
            }
            return ret;
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int[] oldJustficationData = this.justificationData;
            this.justificationData = null;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            if (!this.isJustifyEnabled()) {
                return;
            }
            int currentSpan = 0;
            for (int span : spans) {
                currentSpan += span;
            }
            if (currentSpan == targetSpan) {
                return;
            }
            int extendableSpaces = 0;
            int startJustifiableContent = -1;
            int endJustifiableContent = -1;
            int lastLeadingSpaces = 0;
            int rowStartOffset = this.getStartOffset();
            int rowEndOffset = this.getEndOffset();
            int[] spaceMap = new int[rowEndOffset - rowStartOffset];
            Arrays.fill(spaceMap, 0);
            for (int i = this.getViewCount() - 1; i >= 0; --i) {
                View view = this.getView(i);
                if (!(view instanceof GlyphView)) continue;
                AlterGlyphView.JustificationInfo justificationInfo = ((AlterGlyphView)view).getJustificationInfo(rowStartOffset);
                int viewStartOffset = view.getStartOffset();
                int offset = viewStartOffset - rowStartOffset;
                for (int j = 0; j < justificationInfo.spaceMap.length(); ++j) {
                    if (!justificationInfo.spaceMap.get(j)) continue;
                    spaceMap[j + offset] = 1;
                }
                if (startJustifiableContent > 0) {
                    if (justificationInfo.end >= 0) {
                        extendableSpaces += justificationInfo.trailingSpaces;
                    } else {
                        lastLeadingSpaces += justificationInfo.trailingSpaces;
                    }
                }
                if (justificationInfo.start >= 0) {
                    startJustifiableContent = justificationInfo.start + viewStartOffset;
                    extendableSpaces += lastLeadingSpaces;
                }
                if (justificationInfo.end >= 0 && endJustifiableContent < 0) {
                    endJustifiableContent = justificationInfo.end + viewStartOffset;
                }
                extendableSpaces += justificationInfo.contentSpaces;
                lastLeadingSpaces = justificationInfo.leadingSpaces;
                if (justificationInfo.hasTab) break;
            }
            if (extendableSpaces <= 0) {
                return;
            }
            int adjustment = targetSpan - currentSpan;
            int spaceAddon = extendableSpaces > 0 ? adjustment / extendableSpaces : 0;
            int spaceAddonLeftoverEnd = -1;
            int i = startJustifiableContent - rowStartOffset;
            int leftover = adjustment - spaceAddon * extendableSpaces;
            while (leftover > 0) {
                spaceAddonLeftoverEnd = i;
                leftover -= spaceMap[i];
                ++i;
            }
            if (spaceAddon > 0 || spaceAddonLeftoverEnd >= 0) {
                this.justificationData = oldJustficationData != null ? oldJustficationData : new int[4];
                this.justificationData[0] = spaceAddon;
                this.justificationData[1] = spaceAddonLeftoverEnd;
                this.justificationData[2] = startJustifiableContent - rowStartOffset;
                this.justificationData[3] = endJustifiableContent - rowStartOffset;
                super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            }
        }

        public float getMaximumSpan(int axis) {
            float ret = 0 == axis && this.isJustifyEnabled() ? Float.MAX_VALUE : super.getMaximumSpan(axis);
            return ret;
        }

        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        protected short getLeftInset() {
            int adjustment = 0;
            View parentView = this.getParent();
            if (parentView != null && this == parentView.getView(0)) {
                adjustment = this.firstLineIndent;
            }
            return (short)(super.getLeftInset() + adjustment);
        }

        protected short getBottomInset() {
            return (short)((float)super.getBottomInset() + (float)(this.minorRequest != null ? this.minorRequest.preferred : 0) * this.lineSpacing);
        }
    }

    private static abstract class AlterAbstractDocument
    extends AbstractDocument
    implements Document,
    Serializable {
        static final String I18NProperty = "i18n";

        public AlterAbstractDocument(AbstractDocument.Content data, AbstractDocument.AttributeContext context) {
            super(data, context);
        }

        public AlterAbstractDocument(AbstractDocument.Content data) {
            super(data);
        }
    }

    static class Renderer
    extends WrappedPlainView {
        JXLabel host;
        boolean invalidated = false;
        private float width;
        private float height;
        private View view;
        private ViewFactory factory;

        Renderer(JXLabel c, ViewFactory f, View v, boolean wordWrap) {
            super(null, wordWrap);
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.host = c;
            if (this.host.getVisibleRect().width == 0) {
                this.invalidated = true;
                return;
            }
            int w = this.host.getVisibleRect().width;
            this.setSize(c.getMaxLineSpan() > -1 ? (float)c.getMaxLineSpan() : (float)w, this.host.getVisibleRect().height);
        }

        protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
            if (a != null) {
                this.preferenceChanged(null, true, true);
                Container host = this.getContainer();
                if (host != null) {
                    host.repaint();
                }
            }
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
            if (this.host != null && this.host.painted) {
                this.host.revalidate();
                this.host.repaint();
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            if (g.getClipBounds() == null) {
                g.setClip(alloc);
                this.view.paint(g, allocation);
                g.setClip(null);
            } else {
                this.view.paint(g, allocation);
            }
        }

        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Document getDocument() {
            return this.view == null ? null : this.view.getDocument();
        }

        public void setSize(float width, float height) {
            if (this.host.maxLineSpan > 0) {
                width = Math.min(width, (float)this.host.maxLineSpan);
            }
            if (width == this.width && height == this.height) {
                return;
            }
            this.width = (int)width;
            this.height = (int)height;
            this.view.setSize(width, height == 0.0f ? 32767.0f : height);
            if (this.height == 0.0f) {
                this.height = this.view.getPreferredSpan(1);
            }
        }

        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                int w;
                if (this.invalidated && (w = this.host.getVisibleRect().width) != 0) {
                    this.invalidated = false;
                    this.setSize(w - this.host.getOccupiedWidth(), this.host.getVisibleRect().height);
                }
                return this.width > 0.0f ? this.width : this.view.getPreferredSpan(axis);
            }
            return this.view.getPreferredSpan(axis);
        }

        public Container getContainer() {
            return this.host;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }

        public int getWidth() {
            return (int)this.width;
        }

        public int getHeight() {
            return (int)this.height;
        }
    }

    static class BasicDocument
    extends DefaultStyledDocument {
        BasicDocument(Font defaultFont, Color foreground) {
            this.setFontAndColor(defaultFont, foreground);
        }

        private void setFontAndColor(Font font, Color fg) {
            SimpleAttributeSet attr;
            if (fg != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, fg);
                this.getStyle("default").addAttributes(attr);
            }
            if (font != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, font.getFamily());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, font.getSize());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, font.isBold());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, font.isItalic());
                this.getStyle("default").addAttributes(attr);
            }
            attr = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(attr, 0.0f);
            this.getStyle("default").addAttributes(attr);
        }
    }

    private static class BasicViewFactory
    implements ViewFactory {
        private BasicViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            View view = null;
            if (kind == null) {
                view = new LabelView(elem);
            } else if (kind.equals("content")) {
                view = new LabelView(elem);
            } else if (kind.equals("paragraph")) {
                view = new ParagraphView(elem);
            } else if (kind.equals("section")) {
                view = new BoxView(elem, 1);
            } else if (kind.equals("component")) {
                view = new ComponentView(elem);
            } else if (kind.equals("icon")) {
                view = new IconView(elem);
            }
            return view;
        }
    }

    public static class MultiLineSupport
    implements PropertyChangeListener {
        private static final String HTML = "<html>";
        private static ViewFactory basicViewFactory;
        private static BasicEditorKit basicFactory;

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            JXLabel src = (JXLabel)evt.getSource();
            if ("ancestor".equals(name)) {
                src.dontIgnoreRepaint = true;
            }
            if (src.isLineWrap()) {
                if ("font".equals(name) || "foreground".equals(name) || "maxLineSpan".equals(name)) {
                    if (evt.getOldValue() != null && !MultiLineSupport.isHTML(src.getText())) {
                        MultiLineSupport.updateRenderer(src);
                    }
                } else if ("text".equals(name)) {
                    if (MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        if (src.getClientProperty(JXLabel.oldRendererKey) == null && src.getClientProperty("html") != null) {
                            src.putClientProperty(JXLabel.oldRendererKey, src.getClientProperty("html"));
                        }
                        src.putClientProperty("html", MultiLineSupport.createView(src));
                    } else if (!MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        MultiLineSupport.updateRenderer(src);
                    } else {
                        MultiLineSupport.restoreHtmlRenderer(src);
                    }
                } else if ("lineWrap".equals(name) && !MultiLineSupport.isHTML(src.getText())) {
                    src.putClientProperty("html", MultiLineSupport.createView(src));
                }
            } else if ("lineWrap".equals(name) && !((Boolean)evt.getNewValue()).booleanValue()) {
                MultiLineSupport.restoreHtmlRenderer(src);
            }
        }

        private static void restoreHtmlRenderer(JXLabel src) {
            Object current = src.getClientProperty("html");
            if (current == null || current instanceof Renderer) {
                src.putClientProperty("html", src.getClientProperty(JXLabel.oldRendererKey));
            }
        }

        private static boolean isHTML(String s) {
            return s != null && s.toLowerCase().startsWith(HTML);
        }

        public static View createView(JXLabel c) {
            BasicEditorKit kit = MultiLineSupport.getFactory();
            Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
            StringReader r = new StringReader(c.getText() == null ? "" : c.getText());
            try {
                kit.read(r, doc, 0);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ViewFactory f = kit.getViewFactory();
            View hview = f.create(doc.getDefaultRootElement());
            Renderer v = new Renderer(c, f, hview, true);
            return v;
        }

        public static void updateRenderer(JXLabel c) {
            View value = null;
            View oldValue = (View)c.getClientProperty("html");
            if (oldValue == null || oldValue instanceof Renderer) {
                value = MultiLineSupport.createView(c);
            }
            if (value != oldValue && oldValue != null) {
                for (int i = 0; i < oldValue.getViewCount(); ++i) {
                    oldValue.getView(i).setParent(null);
                }
            }
            c.putClientProperty("html", value);
        }

        private static BasicEditorKit getFactory() {
            if (basicFactory == null) {
                basicViewFactory = new BasicViewFactory();
                basicFactory = new BasicEditorKit();
            }
            return basicFactory;
        }

        private static class BasicEditorKit
        extends StyledEditorKit {
            private BasicEditorKit() {
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground) {
                BasicDocument doc = new BasicDocument(defaultFont, foreground);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                return doc;
            }

            public ViewFactory getViewFactory() {
                return basicViewFactory;
            }
        }
    }
}

