/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

final class DecorationUtils {
    private DecorationUtils() {
    }

    public static Border createSeparateBorder() {
        return new SeparateBorder();
    }

    public static ResizeHandler createResizeHandler(Insets insets) {
        return new ResizeHandler(insets);
    }

    static class ResizeHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Insets insets;
        private int cursorType;
        private boolean isPressed = false;
        private Rectangle resizedBounds = new Rectangle();
        private Rectangle movedBounds = new Rectangle();
        private Point startDragLoc;
        private Rectangle startWinBounds;
        private Dimension minSize;

        public ResizeHandler(Insets insets) {
            this.insets = insets;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.check(mouseEvent);
            Window window = SwingUtilities.getWindowAncestor((Component)mouseEvent.getSource());
            if (0 == this.cursorType) {
                return;
            }
            Rectangle rectangle = this.computeNewBounds(window, this.getScreenLoc(mouseEvent));
            if (!window.getBounds().equals(rectangle)) {
                window.setBounds(rectangle);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.check(mouseEvent);
            Component component = (Component)mouseEvent.getSource();
            this.movedBounds = component.getBounds(this.movedBounds);
            this.cursorType = this.getCursorType(this.movedBounds, mouseEvent.getPoint());
            component.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.isPressed = true;
            this.startDragLoc = this.getScreenLoc(mouseEvent);
            Window window = SwingUtilities.getWindowAncestor((Component)mouseEvent.getSource());
            this.startWinBounds = window.getBounds();
            this.resizedBounds.setBounds(this.startWinBounds);
            this.minSize = window.getMinimumSize();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.isPressed = false;
            this.startDragLoc = null;
            this.startWinBounds = null;
            this.minSize = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            component.setCursor(Cursor.getDefaultCursor());
        }

        private int getCursorType(Rectangle rectangle, Point point) {
            boolean bl;
            int n = point.x - rectangle.x;
            int n2 = rectangle.x + rectangle.width - point.x;
            int n3 = point.y - rectangle.y;
            int n4 = rectangle.y + rectangle.height - point.y;
            boolean bl2 = n3 >= 0 && n3 <= this.insets.top;
            boolean bl3 = n4 >= 0 && n4 <= this.insets.bottom;
            boolean bl4 = n >= 0 && n <= this.insets.left;
            boolean bl5 = n2 >= 0 && n2 <= this.insets.right;
            boolean bl6 = n3 >= 0 && n3 <= this.insets.top + 10;
            boolean bl7 = n4 >= 0 && n4 <= this.insets.bottom + 10;
            boolean bl8 = n >= 0 && n <= this.insets.left + 10;
            boolean bl9 = bl = n2 >= 0 && n2 <= this.insets.right + 10;
            if (bl2 && bl8 || bl6 && bl4) {
                return 6;
            }
            if (bl2 && bl || bl6 && bl5) {
                return 7;
            }
            if (bl3 && bl8 || bl7 && bl4) {
                return 4;
            }
            if (bl3 && bl || bl7 && bl5) {
                return 5;
            }
            if (bl2) {
                return 8;
            }
            if (bl4) {
                return 10;
            }
            if (bl5) {
                return 11;
            }
            if (bl3) {
                return 9;
            }
            return 0;
        }

        private Rectangle computeNewBounds(Window window, Point point) {
            if (this.startDragLoc == null) {
                throw new IllegalArgumentException("Can't compute bounds when startDragLoc is null");
            }
            int n = point.x - this.startDragLoc.x;
            int n2 = point.y - this.startDragLoc.y;
            this.resizedBounds.setBounds(this.startWinBounds);
            switch (this.cursorType) {
                case 11: {
                    this.resizedBounds.width = this.startWinBounds.width + (point.x - this.startDragLoc.x);
                    break;
                }
                case 10: {
                    this.resizedBounds.width = this.startWinBounds.width - n;
                    this.resizedBounds.x = this.startWinBounds.x + n;
                    break;
                }
                case 8: {
                    this.resizedBounds.height = this.startWinBounds.height - n2;
                    this.resizedBounds.y = this.startWinBounds.y + n2;
                    break;
                }
                case 9: {
                    this.resizedBounds.height = this.startWinBounds.height + (point.y - this.startDragLoc.y);
                    break;
                }
                case 7: {
                    ResizeHandler.resize(this.resizedBounds, 0, n2, n, -n2, this.minSize);
                    break;
                }
                case 6: {
                    ResizeHandler.resize(this.resizedBounds, n, n2, -n, -n2, this.minSize);
                    break;
                }
                case 5: {
                    ResizeHandler.resize(this.resizedBounds, 0, 0, n, n2, this.minSize);
                    break;
                }
                case 4: {
                    ResizeHandler.resize(this.resizedBounds, n, 0, -n, n2, this.minSize);
                    break;
                }
                default: {
                    System.out.println("unknown cursor type : " + this.cursorType);
                }
            }
            return this.resizedBounds;
        }

        private static void resize(Rectangle rectangle, int n, int n2, int n3, int n4, Dimension dimension) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.height += n4;
            rectangle.width += n3;
            rectangle.height = Math.max(rectangle.height, dimension.height);
            rectangle.width = Math.max(rectangle.width, dimension.width);
        }

        private Point getScreenLoc(MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getPoint());
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            return point;
        }

        private void check(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (!(object instanceof Component)) {
                throw new IllegalArgumentException("ResizeHandler works only with Component, not with " + object);
            }
            Window window = SwingUtilities.getWindowAncestor((Component)object);
            if (window == null) {
                throw new IllegalStateException("Can't find and resize the window, not attached.");
            }
        }
    }

    private static class SeparateBorder
    extends AbstractBorder {
        private SeparateBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(3, 3, 3, 3);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }
}

