from typing import List
from pyVmomi import vim
from pyVmomi.VmomiSupport import ManagedObject, NoneType


class ContainerView(ManagedObjectView):
    @property
    def container(self) -> vim.ManagedEntity: ...
    @property
    def type(self) -> List[type]: ...
    @property
    def recursive(self) -> bool: ...


class InventoryView(ManagedObjectView):
    def OpenFolder(self, entity: List[vim.ManagedEntity]) -> List[vim.ManagedEntity]: ...
    def CloseFolder(self, entity: List[vim.ManagedEntity]) -> List[vim.ManagedEntity]: ...


class ListView(ManagedObjectView):
    def Modify(self, add: List[ManagedObject], remove: List[ManagedObject]) -> List[ManagedObject]: ...
    def Reset(self, obj: List[ManagedObject]) -> List[ManagedObject]: ...
    def ResetFromView(self, view: View) -> NoneType: ...


class ManagedObjectView(View):
    @property
    def view(self) -> List[ManagedObject]: ...


class View(ManagedObject):
    def Destroy(self) -> NoneType: ...


class ViewManager(ManagedObject):
    @property
    def viewList(self) -> List[View]: ...
    def CreateInventoryView(self) -> InventoryView: ...
    def CreateContainerView(self, container: vim.ManagedEntity, type: List[type], recursive: bool) -> ContainerView: ...
    def CreateListView(self, obj: List[ManagedObject]) -> ListView: ...
    def CreateListViewFromView(self, view: View) -> ListView: ...