/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestSet {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestSet::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("mutate", IngestSet.setHash(processor)));
    }

    static String setHash(Map<String, Map> processor) {
        String painless_condition;
        Map set_json = processor.get("set");
        Object value = set_json.get("value");
        String value_contents = value instanceof String ? IngestConverter.quoteString((String)value) : value;
        if (set_json.containsKey("if") && set_json.get("if") != null && !(painless_condition = (String)set_json.get("if")).isEmpty()) {
            System.out.println("WARN Found in 'set' processor an 'if' painless condition not translated: " + painless_condition);
        }
        String mutate_contents = IngestConverter.createField(IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)set_json.get("field"))), value_contents.toString());
        return IngestConverter.createField("add_field", IngestConverter.wrapInCurly(mutate_contents));
    }

    public static boolean has_set(Map<String, Object> processor) {
        return processor.containsKey("set");
    }
}

