/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.Ack;
import org.logstash.beats.Batch;
import org.logstash.beats.ConnectionHandler;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.Message;

public class BeatsHandler
extends SimpleChannelInboundHandler<Batch> {
    private static final Logger logger = LogManager.getLogger(BeatsHandler.class);
    private final IMessageListener messageListener;
    private ChannelHandlerContext context;
    private static final int MAX_CAUSE_NESTING = 10;

    public BeatsHandler(IMessageListener listener) {
        this.messageListener = listener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        if (logger.isTraceEnabled()) {
            logger.trace(this.format("Channel Active"));
        }
        super.channelActive(ctx);
        this.messageListener.onNewConnection(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (logger.isTraceEnabled()) {
            logger.trace(this.format("Channel Inactive"));
        }
        this.messageListener.onConnectionClose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, Batch batch) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.format("Received a new payload"));
        }
        try {
            if (batch.isEmpty()) {
                logger.debug("Sending 0-seq ACK for empty batch");
                this.writeAck(ctx, batch.getProtocol(), 0);
            }
            for (Message message : batch) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.format("Sending a new message for the listener, sequence: " + message.getSequence()));
                }
                this.messageListener.onNewMessage(ctx, message);
                if (!this.needAck(message)) continue;
                this.ack(ctx, message);
            }
        }
        finally {
            ((AtomicBoolean)ctx.channel().attr(ConnectionHandler.CHANNEL_SEND_KEEP_ALIVE).get()).set(false);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: batches pending: {}", (Object)ctx.channel().id().asShortText(), (Object)((AtomicBoolean)ctx.channel().attr(ConnectionHandler.CHANNEL_SEND_KEEP_ALIVE).get()).get());
            }
            batch.release();
            ctx.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (!(cause instanceof SSLHandshakeException)) {
                this.messageListener.onException(ctx, cause);
            }
            if (this.isNoisyException(cause)) {
                if (logger.isDebugEnabled()) {
                    logger.info(this.format("closing"), cause);
                } else {
                    logger.info(this.format("closing (" + cause.getMessage() + ")"));
                }
            } else {
                Throwable realCause = BeatsHandler.extractCause(cause, 0);
                if (logger.isDebugEnabled()) {
                    logger.info(this.format("Handling exception: " + cause + " (caused by: " + realCause + ")"), cause);
                } else {
                    logger.info(this.format("Handling exception: " + cause + " (caused by: " + realCause + ")"));
                }
                super.exceptionCaught(ctx, cause);
            }
        }
        finally {
            ctx.flush();
            ctx.close();
        }
    }

    private boolean isNoisyException(Throwable ex) {
        String message;
        return ex instanceof IOException && "Connection reset by peer".equals(message = ex.getMessage());
    }

    private boolean needAck(Message message) {
        return message.getSequence() == message.getBatch().getHighestSequence();
    }

    private void ack(ChannelHandlerContext ctx, Message message) {
        if (logger.isTraceEnabled()) {
            logger.trace(this.format("Acking message number " + message.getSequence()));
        }
        this.writeAck(ctx, message.getBatch().getProtocol(), message.getSequence());
    }

    private void writeAck(ChannelHandlerContext ctx, byte protocol, int sequence) {
        ctx.write((Object)new Ack(protocol, sequence));
    }

    private String format(String message) {
        InetSocketAddress local = (InetSocketAddress)this.context.channel().localAddress();
        InetSocketAddress remote = (InetSocketAddress)this.context.channel().remoteAddress();
        String localhost = local != null ? local.getAddress().getHostAddress() + ":" + local.getPort() : "undefined";
        String remotehost = remote != null ? remote.getAddress().getHostAddress() + ":" + remote.getPort() : "undefined";
        return "[local: " + localhost + ", remote: " + remotehost + "] " + message;
    }

    private static Throwable extractCause(Throwable ex, int nesting) {
        Throwable cause = ex.getCause();
        if (cause == null || cause == ex) {
            return ex;
        }
        if (nesting >= 10) {
            return cause;
        }
        return BeatsHandler.extractCause(cause, nesting + 1);
    }
}

