/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.fields;

import org.logstash.dissect.Delimiter;
import org.logstash.dissect.fields.Field;

public abstract class AbstractField
implements Field,
Comparable<Field> {
    private final int ordinal;
    private final Delimiter previous;
    private final Delimiter next;
    private final String name;
    private final String suffix;
    private final Integer id;

    AbstractField(String name, String suffix, int ord) {
        this.ordinal = ord;
        this.name = name;
        this.suffix = suffix;
        this.previous = null;
        this.next = null;
        this.id = 0;
    }

    AbstractField(int id, String name, String suffix, int ordinal, Delimiter previous, Delimiter next) {
        this.name = name;
        this.suffix = suffix;
        this.ordinal = ordinal;
        this.previous = previous;
        this.next = next;
        if (this.next != null) {
            this.next.setGreedy(this.suffix.contains("->"));
        }
        this.id = id;
    }

    @Override
    public final int compareTo(Field field) {
        return Integer.compare(this.id, field.hashCode());
    }

    public final int hashCode() {
        return this.id;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Field && this.hashCode() == obj.hashCode();
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final int id() {
        return this.id;
    }

    @Override
    public final int ordinal() {
        return this.ordinal;
    }

    final String joinString() {
        if (this.previous == null || this.previous.size() == 0) {
            return " ";
        }
        return this.previous.getDelimiter();
    }

    @Override
    public final Delimiter nextDelimiter() {
        return this.next;
    }

    @Override
    public final Delimiter previousDelimiter() {
        return this.previous;
    }

    final String buildToString(String className) {
        return className + '{' + "name=" + this.name() + ", ordinal=" + this.ordinal() + ", previous=" + this.previous + ", next=" + this.next + '}';
    }
}

