/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyMethod;
import org.jruby.RubyString;
import org.jruby.exceptions.NameError;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

public final class RubyBasicObjectSerializer
extends StdSerializer<RubyBasicObject> {
    private static final long serialVersionUID = -5557562960691452054L;
    private static final Logger LOGGER = LogManager.getLogger(RubyBasicObjectSerializer.class);
    private static final String METHOD_INSPECT = "inspect";
    private static final String METHOD_TO_STRING = "to_s";

    public RubyBasicObjectSerializer() {
        super(RubyBasicObject.class);
    }

    public void serialize(RubyBasicObject value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Optional<JsonSerializer<Object>> serializer = this.findTypeSerializer(value, provider);
        if (serializer.isPresent()) {
            try {
                serializer.get().serialize((Object)value, gen, provider);
                return;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to serialize value type {} using default serializer {}", value.getClass(), serializer.get().getClass(), (Object)e);
            }
        }
        if (this.isCustomInspectMethodDefined(value)) {
            try {
                gen.writeString(value.callMethod(METHOD_INSPECT).asJavaString());
                return;
            }
            catch (Exception e) {
                LOGGER.debug("Failed to serialize value type {} using the custom `inspect` method", (Object)value.getMetaClass(), (Object)e);
            }
        }
        try {
            gen.writeString(value.callMethod(METHOD_TO_STRING).asJavaString());
            return;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to serialize value type {} using `to_s` method", (Object)value.getMetaClass(), (Object)e);
            try {
                gen.writeString(value.to_s().asJavaString());
            }
            catch (Exception e2) {
                LOGGER.debug("Failed to serialize value type {} using `RubyBasicObject#to_s()` method", (Object)value.getMetaClass(), (Object)e2);
                gen.writeString(value.anyToString().asJavaString());
            }
            return;
        }
    }

    private Optional<JsonSerializer<Object>> findTypeSerializer(RubyBasicObject value, SerializerProvider provider) {
        if (ClassUtil.isCollectionMapOrArray(value.getClass())) {
            try {
                return Optional.ofNullable(provider.findTypedValueSerializer(value.getJavaClass(), false, null));
            }
            catch (JsonMappingException jsonMappingException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private boolean isCustomInspectMethodDefined(RubyBasicObject value) {
        try {
            IRubyObject candidate = value.method((IRubyObject)RubyString.newString((Ruby)RubyUtil.RUBY, (String)METHOD_INSPECT));
            return candidate instanceof RubyMethod && ((RubyMethod)candidate).owner(RubyUtil.RUBY.getCurrentContext()).toString().toLowerCase().startsWith("logstash");
        }
        catch (NameError e) {
            return false;
        }
    }
}

