/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.LogicalCallableStatement;
import org.apache.derby.client.am.LogicalPreparedStatement;
import org.apache.derby.client.am.LogicalStatementEntity;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.client.am.stmtcache.StatementKeyFactory;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class StatementCacheInteractor {
    private final JDBCStatementCache cache;
    private final ClientConnection physicalConnection;
    private final ArrayList<LogicalStatementEntity> openLogicalStatements = new ArrayList();
    private boolean connCloseInProgress = false;

    StatementCacheInteractor(JDBCStatementCache cache, ClientConnection physicalConnection) {
        this.cache = cache;
        this.physicalConnection = physicalConnection;
    }

    synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newPrepared(sql, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.holdability());
        PreparedStatement ps = this.cache.getCached(stmtKey);
        if (ps == null) {
            ps = this.physicalConnection.prepareStatement(sql);
        }
        return this.createLogicalPreparedStatement(ps, stmtKey);
    }

    synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newPrepared(sql, this.physicalConnection.getCurrentSchemaName(), resultSetType, resultSetConcurrency, this.physicalConnection.holdability());
        PreparedStatement ps = this.cache.getCached(stmtKey);
        if (ps == null) {
            ps = this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return this.createLogicalPreparedStatement(ps, stmtKey);
    }

    synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newPrepared(sql, this.physicalConnection.getCurrentSchemaName(), resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatement ps = this.cache.getCached(stmtKey);
        if (ps == null) {
            ps = this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.createLogicalPreparedStatement(ps, stmtKey);
    }

    synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newPrepared(sql, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.getHoldability(), autoGeneratedKeys);
        PreparedStatement ps = this.cache.getCached(stmtKey);
        if (ps == null) {
            ps = this.physicalConnection.prepareStatement(sql, autoGeneratedKeys);
        }
        return this.createLogicalPreparedStatement(ps, stmtKey);
    }

    synchronized CallableStatement prepareCall(String sql) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newCallable(sql, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.holdability());
        CallableStatement cs = (CallableStatement)this.cache.getCached(stmtKey);
        if (cs == null) {
            cs = this.physicalConnection.prepareCall(sql);
        }
        return this.createLogicalCallableStatement(cs, stmtKey);
    }

    synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newCallable(sql, this.physicalConnection.getCurrentSchemaName(), resultSetType, resultSetConcurrency, this.physicalConnection.holdability());
        CallableStatement cs = (CallableStatement)this.cache.getCached(stmtKey);
        if (cs == null) {
            cs = this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        return this.createLogicalCallableStatement(cs, stmtKey);
    }

    synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementKey stmtKey = StatementKeyFactory.newCallable(sql, this.physicalConnection.getCurrentSchemaName(), resultSetType, resultSetConcurrency, resultSetHoldability);
        CallableStatement cs = (CallableStatement)this.cache.getCached(stmtKey);
        if (cs == null) {
            cs = this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.createLogicalCallableStatement(cs, stmtKey);
    }

    synchronized void closeOpenLogicalStatements() throws SQLException {
        this.connCloseInProgress = true;
        for (LogicalStatementEntity logicalStatement : this.openLogicalStatements) {
            logicalStatement.close();
        }
        this.openLogicalStatements.clear();
    }

    synchronized void markClosed(LogicalStatementEntity logicalStmt) {
        if (!this.connCloseInProgress) {
            boolean removed = this.openLogicalStatements.remove(logicalStmt);
            SanityManager.ASSERT((boolean)removed, (String)("Tried to remove unregistered logical statement: " + logicalStmt));
        }
    }

    private PreparedStatement createLogicalPreparedStatement(PreparedStatement ps, StatementKey stmtKey) throws SQLException {
        LogicalPreparedStatement logicalPs = ClientAutoloadedDriver.getFactory().newLogicalPreparedStatement(ps, stmtKey, this);
        this.openLogicalStatements.add(logicalPs);
        return logicalPs;
    }

    private CallableStatement createLogicalCallableStatement(CallableStatement cs, StatementKey stmtKey) throws SQLException {
        LogicalCallableStatement logicalCs = ClientAutoloadedDriver.getFactory().newLogicalCallableStatement(cs, stmtKey, this);
        this.openLogicalStatements.add(logicalCs);
        return logicalCs;
    }

    JDBCStatementCache getCache() {
        return this.cache;
    }
}

