/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class CreateIndexNode
extends DDLStatementNode {
    private boolean unique;
    private Properties properties;
    private String indexType;
    private TableName indexName;
    private TableName tableName;
    private List<String> columnNameList;
    private String[] columnNames;
    private boolean[] isAscending;
    private int[] boundColumnIDs;
    private TableDescriptor td;

    CreateIndexNode(boolean unique, String indexType, TableName indexName, TableName tableName, List<String> columnNameList, Properties properties, ContextManager cm) throws StandardException {
        super(indexName, cm);
        this.unique = unique;
        this.indexType = indexType;
        this.indexName = indexName;
        this.tableName = tableName;
        this.columnNameList = columnNameList;
        this.properties = properties;
    }

    @Override
    public String toString() {
        return super.toString() + "unique: " + this.unique + "\nindexType: " + this.indexType + "\nindexName: " + this.indexName + "\ntableName: " + this.tableName + "\nproperties: " + this.properties + "\n";
    }

    @Override
    String statementToString() {
        return "CREATE INDEX";
    }

    @Override
    public void bindStatement() throws StandardException {
        this.getSchemaDescriptor();
        this.td = this.getTableDescriptor(this.tableName);
        if (this.td.getTableType() == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        if (this.td.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException((String)"42Z9F", (Object[])new Object[]{String.valueOf(this.td.getTotalNumberOfIndexes()), this.tableName, String.valueOf(Short.MAX_VALUE)});
        }
        this.verifyAndGetUniqueNames();
        int columnCount = this.columnNames.length;
        this.boundColumnIDs = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException((String)"42X14", (Object[])new Object[]{this.columnNames[i], this.tableName});
            }
            this.boundColumnIDs[i] = columnDescriptor.getPosition();
            if (columnDescriptor.getType().getTypeId().orderable(this.getClassFactory())) continue;
            throw StandardException.newException((String)"X0X67.S", (Object[])new Object[]{columnDescriptor.getType().getTypeId().getSQLTypeName()});
        }
        if (columnCount > 16) {
            throw StandardException.newException((String)"54008", (Object[])new Object[0]);
        }
        this.getCompilerContext().createDependency(this.td);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return CreateIndexNode.isSessionSchema(this.td.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor();
        int columnCount = this.columnNames.length;
        int approxLength = 0;
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            DataTypeDescriptor dts = columnDescriptor.getType();
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (approxLength > 1024 && (this.properties == null || this.properties.get("derby.storage.pageSize") == null) && PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") == null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(false, this.unique, false, false, false, -1, this.indexType, sd.getSchemaName(), this.indexName.getTableName(), this.tableName.getTableName(), this.td.getUUID(), this.columnNames, this.isAscending, false, null, this.properties);
    }

    private void verifyAndGetUniqueNames() throws StandardException {
        int size = this.columnNameList.size();
        HashSet<String> seenNames = new HashSet<String>(size + 2, 0.999f);
        this.columnNames = new String[size];
        this.isAscending = new boolean[size];
        for (int index = 0; index < size; ++index) {
            boolean alreadySeen;
            this.columnNames[index] = this.columnNameList.get(index);
            if (this.columnNames[index].endsWith(" ")) {
                this.columnNames[index] = this.columnNames[index].substring(0, this.columnNames[index].length() - 1);
                this.isAscending[index] = false;
            } else {
                this.isAscending[index] = true;
            }
            boolean bl = alreadySeen = !seenNames.add(this.columnNames[index]);
            if (!alreadySeen) continue;
            throw StandardException.newException((String)"42X66", (Object[])new Object[]{this.columnNames[index]});
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.indexName != null) {
            this.indexName = (TableName)this.indexName.accept(v);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(v);
        }
    }
}

