/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.impl.services.cache.ReplacementPolicy;
import org.apache.derby.shared.common.sanity.SanityManager;

final class CacheEntry {
    private final ReentrantLock mutex = new ReentrantLock();
    private Cacheable cacheable;
    private int keepCount;
    private Condition forRemove;
    private Condition settingIdentity = this.mutex.newCondition();
    private ReplacementPolicy.Callback callback;

    CacheEntry() {
    }

    void lock() {
        SanityManager.ASSERT((!this.mutex.isHeldByCurrentThread() ? 1 : 0) != 0);
        this.mutex.lock();
    }

    void waitUntilIdentityIsSet() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        while (this.settingIdentity != null) {
            this.settingIdentity.awaitUninterruptibly();
        }
    }

    void unlock() {
        this.mutex.unlock();
    }

    void settingIdentityComplete() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        this.settingIdentity.signalAll();
        this.settingIdentity = null;
    }

    void keep(boolean accessed) {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        ++this.keepCount;
        if (accessed) {
            this.callback.access();
        }
    }

    void unkeep() {
        SanityManager.ASSERT((boolean)this.isKept());
        --this.keepCount;
        if (this.forRemove != null && this.keepCount == 1) {
            this.forRemove.signal();
        }
    }

    boolean isKept() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        SanityManager.ASSERT((this.keepCount >= 0 ? 1 : 0) != 0);
        return this.keepCount > 0;
    }

    void unkeepForRemove() {
        SanityManager.ASSERT((boolean)this.isKept());
        SanityManager.ASSERT((this.forRemove == null ? 1 : 0) != 0);
        if (this.keepCount > 1) {
            this.forRemove = this.mutex.newCondition();
            while (this.keepCount > 1) {
                this.forRemove.awaitUninterruptibly();
            }
            this.forRemove = null;
        }
        --this.keepCount;
    }

    void setCacheable(Cacheable c) {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        this.cacheable = c;
    }

    Cacheable getCacheable() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        return this.cacheable;
    }

    boolean isValid() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        return this.settingIdentity == null && this.cacheable != null;
    }

    void setCallback(ReplacementPolicy.Callback cb) {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        this.callback = cb;
    }

    void free() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        if (this.callback != null) {
            this.callback.free();
        }
        this.cacheable = null;
    }
}

