/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;

public class AddClientListenerOperation
extends ClientListenerOperation {
    private final byte[][] filterFactoryParams;
    private final byte[][] converterFactoryParams;
    private final InternalRemoteCache<?, ?> remoteCache;
    private final TelemetryService telemetryService;

    protected AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat, InternalRemoteCache<?, ?> remoteCache, TelemetryService telemetryService) {
        this(codec, channelFactory, cacheName, clientTopology, flags, cfg, AddClientListenerOperation.generateListenerId(), listenerNotifier, listener, filterFactoryParams, converterFactoryParams, dataFormat, remoteCache, telemetryService);
    }

    private AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] listenerId, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat, InternalRemoteCache<?, ?> remoteCache, TelemetryService telemetryService) {
        super((short)37, (short)38, codec, channelFactory, RemoteCacheManager.cacheNameBytes(cacheName), clientTopology, flags, cfg, listenerId, dataFormat, listener, cacheName, listenerNotifier, telemetryService);
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
        this.remoteCache = remoteCache;
        this.telemetryService = telemetryService;
    }

    @Override
    public AddClientListenerOperation copy() {
        return new AddClientListenerOperation(this.codec, this.channelFactory, this.cacheNameString, this.header.getClientTopology(), this.flags(), this.cfg, this.listenerId, this.listenerNotifier, this.listener, this.filterFactoryParams, this.converterFactoryParams, this.dataFormat(), this.remoteCache, this.telemetryService);
    }

    @Override
    protected void actualExecute(Channel channel) {
        ClientListener clientListener = this.extractClientListener();
        ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registerOperation(channel, this);
        this.listenerNotifier.addDispatcher(ClientEventDispatcher.create(this, this.address, () -> this.cleanup(channel), this.remoteCache));
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        this.codec.writeClientListenerParams(buf, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        this.codec.writeClientListenerInterests(buf, ClientEventDispatcher.findMethods(this.listener).keySet());
        channel.writeAndFlush((Object)buf);
    }
}

