/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.securityscheme;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.oauth.OAuthWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class SecuritySchemeWriter {
    private SecuritySchemeWriter() {
    }

    public static void writeSecuritySchemes(ObjectNode parent, Map<String, SecurityScheme> securitySchemes) {
        if (securitySchemes == null) {
            return;
        }
        ObjectNode securitySchemesNode = parent.putObject("securitySchemes");
        for (Map.Entry<String, SecurityScheme> entry : securitySchemes.entrySet()) {
            SecuritySchemeWriter.writeSecurityScheme(securitySchemesNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeSecurityScheme(ObjectNode parent, SecurityScheme model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.enumProperty(node, "type", model.getType());
            JsonUtil.stringProperty(node, "description", model.getDescription());
            JsonUtil.stringProperty(node, "name", model.getName());
            JsonUtil.enumProperty(node, "in", model.getIn());
            JsonUtil.stringProperty(node, "scheme", model.getScheme());
            JsonUtil.stringProperty(node, "bearerFormat", model.getBearerFormat());
            OAuthWriter.writeOAuthFlows(node, model.getFlows());
            JsonUtil.stringProperty(node, "openIdConnectUrl", model.getOpenIdConnectUrl());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

