/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class AddManyFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<AddManyFunction> EXTERNALIZER = new Externalizer();
    private final Collection<ScoredValue<V>> scoredValues;
    private final boolean addOnly;
    private final boolean updateOnly;
    private final boolean updateLessScoresOnly;
    private final boolean updateGreaterScoresOnly;
    private final boolean returnChangedCount;
    private final boolean replace;

    public AddManyFunction(Collection<ScoredValue<V>> scoredValues, SortedSetAddArgs args) {
        this.scoredValues = scoredValues;
        this.addOnly = args.addOnly;
        this.updateOnly = args.updateOnly;
        this.updateLessScoresOnly = args.updateLessScoresOnly;
        this.updateGreaterScoresOnly = args.updateGreaterScoresOnly;
        this.returnChangedCount = args.returnChangedCount;
        this.replace = args.replace;
    }

    public AddManyFunction(Collection<ScoredValue<V>> scoredValues, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly, boolean returnChangedCount, boolean replace) {
        this.scoredValues = scoredValues;
        this.addOnly = addOnly;
        this.updateOnly = updateOnly;
        this.updateLessScoresOnly = updateLessScoresOnly;
        this.updateGreaterScoresOnly = updateGreaterScoresOnly;
        this.returnChangedCount = returnChangedCount;
        this.replace = replace;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        SortedSetBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (SortedSetBucket<V>)existing.get();
        } else if (!this.updateOnly || !this.replace) {
            bucket = new SortedSetBucket<V>();
        }
        if (bucket != null) {
            if (this.replace) {
                bucket.replace(this.scoredValues);
                if (bucket.size() == 0L) {
                    entryView.remove();
                } else {
                    entryView.set(bucket, new MetaParam.Writable[0]);
                }
                return bucket.size();
            }
            SortedSetBucket.AddOrUpdatesCounters addResult = bucket.addMany(this.scoredValues, this.addOnly, this.updateOnly, this.updateLessScoresOnly, this.updateGreaterScoresOnly);
            if (addResult.updated > 0L || addResult.created > 0L) {
                entryView.set(bucket, new MetaParam.Writable[0]);
            }
            return this.returnChangedCount ? addResult.created + addResult.updated : addResult.created;
        }
        return 0L;
    }

    private static class Externalizer
    implements AdvancedExternalizer<AddManyFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends AddManyFunction>> getTypeClasses() {
            return Collections.singleton(AddManyFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_ADD_MANY_FUNCTION;
        }

        public void writeObject(ObjectOutput output, AddManyFunction object) throws IOException {
            MarshallUtil.marshallCollection(object.scoredValues, (ObjectOutput)output);
            output.writeBoolean(object.addOnly);
            output.writeBoolean(object.updateOnly);
            output.writeBoolean(object.updateLessScoresOnly);
            output.writeBoolean(object.updateGreaterScoresOnly);
            output.writeBoolean(object.returnChangedCount);
            output.writeBoolean(object.replace);
        }

        public AddManyFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Collection scoredValues = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            return new AddManyFunction(scoredValues, input.readBoolean(), input.readBoolean(), input.readBoolean(), input.readBoolean(), input.readBoolean(), input.readBoolean());
        }
    }
}

