/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.metrics;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/metrics/JvmMetrics;", "", "<init>", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "gcType", "Lorg/jitsi/videobridge/metrics/JvmMetrics$GcType;", "update", "", "threadCount", "Lorg/jitsi/metrics/LongGaugeMetric;", "getThreadCount", "()Lorg/jitsi/metrics/LongGaugeMetric;", "gcCount", "gcTime", "heapCommitted", "heapUsed", "openFdCount", "GcType", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nJvmMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmMetrics.kt\norg/jitsi/videobridge/metrics/JvmMetrics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,107:1\n1#2:108\n68#3,6:109\n*S KotlinDebug\n*F\n+ 1 JvmMetrics.kt\norg/jitsi/videobridge/metrics/JvmMetrics\n*L\n99#1:109,6\n*E\n"})
public final class JvmMetrics {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    @NotNull
    private final GcType gcType;
    @NotNull
    private final LongGaugeMetric threadCount;
    @NotNull
    private final LongGaugeMetric gcCount;
    @NotNull
    private final LongGaugeMetric gcTime;
    @NotNull
    private final LongGaugeMetric heapCommitted;
    @NotNull
    private final LongGaugeMetric heapUsed;
    @NotNull
    private final LongGaugeMetric openFdCount;
    @NotNull
    private static final ConfigDelegate<Boolean> enable$delegate;
    @Nullable
    private static final JvmMetrics INSTANCE;

    private JvmMetrics() {
        GcType gcType;
        GcType gcType2;
        GcType it;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, "getGarbageCollectorMXBeans(...)");
        GarbageCollectorMXBean garbageCollectorMXBean = CollectionsKt.firstOrNull(list);
        String string = garbageCollectorMXBean != null ? garbageCollectorMXBean.getName() : null;
        JvmMetrics jvmMetrics = this;
        boolean bl = false;
        void v2 = it;
        boolean bl2 = v2 != null ? StringsKt.contains((CharSequence)v2, "shenandoah", true) : false;
        if (bl2) {
            gcType2 = GcType.Shenandoah;
        } else {
            void v5 = it;
            boolean bl3 = v5 != null ? StringsKt.contains((CharSequence)v5, "zgc", true) : false;
            if (bl3) {
                gcType2 = GcType.Zgc;
            } else {
                void v7 = it;
                gcType2 = (v7 != null ? StringsKt.contains((CharSequence)v7, "g1", true) : false) ? GcType.G1 : GcType.Other;
            }
        }
        it = gcType = gcType2;
        boolean bl4 = false;
        this.logger.info("Detected GC type " + it);
        jvmMetrics.gcType = gcType;
        this.threadCount = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "thread_count", "Current number of JVM threads.", 0L, 4, null);
        this.gcCount = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "jvm_gc_count", "Garbage collection count.", 0L, 4, null);
        this.gcTime = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "jvm_gc_time", "Garbage collection time.", 0L, 4, null);
        this.heapCommitted = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "jvm_heap_committed", "Capacity of the main memory pool for the heap (GC type specific).", 0L, 4, null);
        this.heapUsed = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "jvm_heap_used", "Usage of the main memory pool for the heap (GC type specific).", 0L, 4, null);
        this.openFdCount = MetricsContainer.registerLongGauge$default(VideobridgeMetricsContainer.Companion.getInstance(), "jvm_open_fd_count", "Number of open file descriptors.", 0L, 4, null);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void update() {
        block6: {
            Object v4;
            Object it;
            block5: {
                long l;
                PlatformManagedObject it2;
                long l2;
                this.threadCount.set(ManagementFactory.getThreadMXBean().getThreadCount());
                List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
                Intrinsics.checkNotNullExpressionValue(list, "getGarbageCollectorMXBeans(...)");
                Iterable iterable = list;
                LongGaugeMetric longGaugeMetric = this.gcCount;
                long l3 = 0L;
                for (Object t2 : iterable) {
                    GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)t2;
                    l2 = l3;
                    boolean bl = false;
                    l = it2.getCollectionCount();
                    l3 = l2 + l;
                }
                l2 = l3;
                longGaugeMetric.set(l2);
                List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
                Intrinsics.checkNotNullExpressionValue(list2, "getGarbageCollectorMXBeans(...)");
                iterable = list2;
                longGaugeMetric = this.gcTime;
                l3 = 0L;
                for (Object t2 : iterable) {
                    it2 = (GarbageCollectorMXBean)t2;
                    l2 = l3;
                    boolean bl = false;
                    l = it2.getCollectionTime();
                    l3 = l2 + l;
                }
                l2 = l3;
                longGaugeMetric.set(l2);
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                UnixOperatingSystemMXBean unixOperatingSystemMXBean = operatingSystemMXBean instanceof UnixOperatingSystemMXBean ? (UnixOperatingSystemMXBean)operatingSystemMXBean : null;
                if (unixOperatingSystemMXBean != null) {
                    it = unixOperatingSystemMXBean;
                    boolean bl = false;
                    this.openFdCount.set(it.getOpenFileDescriptorCount());
                }
                if (this.gcType == GcType.Other) break block6;
                List<MemoryPoolMXBean> list3 = ManagementFactory.getMemoryPoolMXBeans();
                Intrinsics.checkNotNullExpressionValue(list3, "getMemoryPoolMXBeans(...)");
                it = list3;
                Iterator bl = it.iterator();
                while (bl.hasNext()) {
                    Object t2;
                    t2 = bl.next();
                    it2 = (MemoryPoolMXBean)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it2.getName(), this.gcType.getMemoryPoolName())) continue;
                    v4 = t2;
                    break block5;
                }
                v4 = null;
            }
            MemoryPoolMXBean memoryPoolMXBean = v4;
            if (memoryPoolMXBean != null) {
                it = memoryPoolMXBean;
                boolean bl = false;
                this.heapUsed.set(it.getUsage().getUsed());
                this.heapCommitted.set(it.getUsage().getCommitted());
            }
        }
    }

    @NotNull
    public final LongGaugeMetric getThreadCount() {
        return this.threadCount;
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$enable_delegate_u24lambda_u247 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl = false;
        $this$enable_delegate_u24lambda_u247.from("videobridge.stats.jvm.enabled", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        enable$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        INSTANCE = Companion.getEnable() ? new JvmMetrics() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/metrics/JvmMetrics$Companion;", "", "<init>", "()V", "enable", "", "getEnable", "()Z", "enable$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "INSTANCE", "Lorg/jitsi/videobridge/metrics/JvmMetrics;", "getINSTANCE", "()Lorg/jitsi/videobridge/metrics/JvmMetrics;", "update", "", "()Lkotlin/Unit;", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        public final boolean getEnable() {
            return (Boolean)enable$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @Nullable
        public final JvmMetrics getINSTANCE() {
            return INSTANCE;
        }

        @Nullable
        public final Unit update() {
            Unit unit;
            JvmMetrics jvmMetrics = this.getINSTANCE();
            if (jvmMetrics != null) {
                jvmMetrics.update();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "enable", "getEnable()Z", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jitsi/videobridge/metrics/JvmMetrics$GcType;", "", "memoryPoolName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMemoryPoolName", "()Ljava/lang/String;", "G1", "Zgc", "Shenandoah", "Other", "jitsi-videobridge"})
    private static final class GcType
    extends Enum<GcType> {
        @Nullable
        private final String memoryPoolName;
        public static final /* enum */ GcType G1 = new GcType("G1 Old Gen");
        public static final /* enum */ GcType Zgc = new GcType("ZHeap");
        public static final /* enum */ GcType Shenandoah = new GcType("Shenandoah");
        public static final /* enum */ GcType Other = new GcType(null);
        private static final /* synthetic */ GcType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GcType(String memoryPoolName) {
            this.memoryPoolName = memoryPoolName;
        }

        @Nullable
        public final String getMemoryPoolName() {
            return this.memoryPoolName;
        }

        public static GcType[] values() {
            return (GcType[])$VALUES.clone();
        }

        public static GcType valueOf(String value2) {
            return Enum.valueOf(GcType.class, value2);
        }

        @NotNull
        public static EnumEntries<GcType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gcTypeArray = new GcType[]{GcType.G1, GcType.Zgc, GcType.Shenandoah, GcType.Other};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

