/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class SRV
extends Data
implements Comparable<SRV> {
    public final int priority;
    public final int weight;
    public final int port;
    public final DnsName target;
    @Deprecated
    public final DnsName name;

    public static SRV parse(DataInputStream dis, byte[] data2) throws IOException {
        int priority = dis.readUnsignedShort();
        int weight = dis.readUnsignedShort();
        int port2 = dis.readUnsignedShort();
        DnsName name = DnsName.parse(dis, data2);
        return new SRV(priority, weight, port2, name);
    }

    public SRV(int priority, int weight, int port2, String name) {
        this(priority, weight, port2, DnsName.from(name));
    }

    public SRV(int priority, int weight, int port2, DnsName name) {
        this.priority = priority;
        this.weight = weight;
        this.port = port2;
        this.name = this.target = name;
    }

    public boolean isServiceAvailable() {
        return !this.target.isRootLabel();
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.priority);
        dos.writeShort(this.weight);
        dos.writeShort(this.port);
        this.target.writeToStream(dos);
    }

    public String toString() {
        return this.priority + " " + this.weight + " " + this.port + " " + this.target + ".";
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.SRV;
    }

    @Override
    public int compareTo(SRV other) {
        int res = other.priority - this.priority;
        if (res == 0) {
            res = this.weight - other.weight;
        }
        return res;
    }
}

