/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class Media
extends AbstractPacketExtension {
    public static final String ELEMENT = "media";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "media");
    public static final String TYPE_ATTR_NAME = "type";

    public Media() {
        super(NAMESPACE, ELEMENT);
    }

    private Media(Builder b) {
        super(NAMESPACE, ELEMENT);
        if (b.type == null) {
            throw new IllegalArgumentException("Media type must be set");
        }
        this.setAttribute(TYPE_ATTR_NAME, b.type.toString());
        for (PayloadTypePacketExtension pt : b.payloadTypes) {
            this.addChildExtension(pt);
        }
        for (RTPHdrExtPacketExtension ext : b.rtpHeaderExtensions) {
            this.addChildExtension(ext);
        }
        if (b.extmapAllowMixed != null) {
            this.addChildExtension(b.extmapAllowMixed);
        }
    }

    @NotNull
    public MediaType getType() {
        return MediaType.parseString(this.getAttributeAsString(TYPE_ATTR_NAME));
    }

    @NotNull
    public List<PayloadTypePacketExtension> getPayloadTypes() {
        return this.getChildExtensionsOfType(PayloadTypePacketExtension.class);
    }

    @NotNull
    public List<RTPHdrExtPacketExtension> getRtpHdrExts() {
        return this.getChildExtensionsOfType(RTPHdrExtPacketExtension.class);
    }

    @Nullable
    public ExtmapAllowMixedPacketExtension getExtmapAllowMixed() {
        return this.getFirstChildOfType(ExtmapAllowMixedPacketExtension.class);
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Provider
    extends DefaultPacketExtensionProvider<Media> {
        public Provider() {
            super(Media.class);
        }

        @Override
        public Media parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            Media m = (Media)super.parse(parser, depth, xmlEnvironment);
            String type2 = m.getAttributeAsString(Media.TYPE_ATTR_NAME);
            if (type2 == null) {
                throw new SmackParsingException.RequiredAttributeMissingException(Media.TYPE_ATTR_NAME);
            }
            try {
                MediaType.parseString(type2);
            }
            catch (IllegalArgumentException e) {
                throw new SmackParsingException("type:" + e.getMessage());
            }
            return m;
        }
    }

    public static final class Builder {
        MediaType type = null;
        private final List<PayloadTypePacketExtension> payloadTypes = new ArrayList<PayloadTypePacketExtension>();
        private final List<RTPHdrExtPacketExtension> rtpHeaderExtensions = new ArrayList<RTPHdrExtPacketExtension>();
        private ExtmapAllowMixedPacketExtension extmapAllowMixed = null;

        public Builder setType(MediaType t) {
            this.type = t;
            return this;
        }

        public Builder addPayloadType(PayloadTypePacketExtension pt) {
            this.payloadTypes.add(pt);
            return this;
        }

        public Builder addRtpHdrExt(RTPHdrExtPacketExtension ext) {
            this.rtpHeaderExtensions.add(ext);
            return this;
        }

        public Builder setExtmapAllowMixed(ExtmapAllowMixedPacketExtension ext) {
            this.extmapAllowMixed = ext;
            return this;
        }

        private Builder() {
        }

        @Contract(value=" -> new")
        @NotNull
        public Media build() {
            return new Media(this);
        }
    }
}

