/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo.api;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.duo.api.DuoCookie;

public class SignedDuoCookie
extends DuoCookie {
    private static final Pattern SIGNED_COOKIE_FORMAT = Pattern.compile("([^|]+)\\|([^|]+)\\|([0-9a-f]+)");
    private static final int PREFIX_GROUP = 1;
    private static final int DATA_GROUP = 2;
    private static final int SIGNATURE_GROUP = 3;
    private static final String SIGNATURE_ALGORITHM = "HmacSHA1";
    private final Type type;
    private final String signature;

    public SignedDuoCookie(DuoCookie cookie, Type type, String key) throws GuacamoleException {
        super(cookie.getUsername(), cookie.getIntegrationKey(), cookie.getExpirationTimestamp());
        this.type = type;
        this.signature = SignedDuoCookie.sign(key, type.getPrefix() + "|" + cookie.toString());
    }

    private static String sign(String key, String data) throws GuacamoleException {
        try {
            Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
            mac.init(new SecretKeySpec(key.getBytes("UTF-8"), SIGNATURE_ALGORITHM));
            return BaseEncoding.base16().lowerCase().encode(mac.doFinal(data.getBytes("UTF-8")));
        }
        catch (InvalidKeyException e) {
            throw new GuacamoleServerException("Signing key is invalid.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Unexpected lack of support for required signature algorithm \"HmacSHA1\".", e);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getSignature() {
        return this.signature;
    }

    public static SignedDuoCookie parseSignedDuoCookie(String key, String str) throws GuacamoleException {
        Matcher matcher = SIGNED_COOKIE_FORMAT.matcher(str);
        if (!matcher.matches()) {
            throw new GuacamoleClientException("Format of signed Duo cookie is invalid.");
        }
        Type type = Type.fromPrefix(matcher.group(1));
        if (type == null) {
            throw new GuacamoleClientException("Invalid Duo cookie prefix.");
        }
        DuoCookie cookie = DuoCookie.parseDuoCookie(matcher.group(2));
        SignedDuoCookie signedCookie = new SignedDuoCookie(cookie, type, key);
        if (!signedCookie.getSignature().equals(matcher.group(3))) {
            throw new GuacamoleClientException("Duo cookie has incorrect signature.");
        }
        return signedCookie;
    }

    @Override
    public String toString() {
        return this.type.getPrefix() + "|" + super.toString() + "|" + this.signature;
    }

    public static enum Type {
        DUO_REQUEST("TX"),
        DUO_RESPONSE("AUTH"),
        APPLICATION("APP");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public static Type fromPrefix(String prefix) {
            for (Type type : Type.values()) {
                if (!type.getPrefix().equals(prefix)) continue;
                return type;
            }
            return null;
        }
    }
}

