/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.signatureengine;

import de.rub.nds.signatureengine.SignatureEngine;
import de.rub.nds.signatureengine.SignatureEngineException;
import de.rub.nds.signatureengine.keyparsers.KeyParser;
import de.rub.nds.signatureengine.keyparsers.KeyParserException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public abstract class JavaSignatureEngine
extends SignatureEngine {
    private final Signature signature;
    private KeyParser keyParser;
    private PrivateKey privateKey = null;
    private boolean isInitialized = false;

    public JavaSignatureEngine(String signatureAlgorithm, KeyParser keyParser) throws SignatureEngineException {
        if (keyParser == null) {
            throw new SignatureEngineException("No key parser specified!");
        }
        this.keyParser = keyParser;
        try {
            this.signature = Signature.getInstance(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureEngineException(e);
        }
    }

    @Override
    public void init(byte[] keyBytes, SignatureEngine.KeyType keyType, byte[] parameters) throws SignatureEngineException {
        try {
            this.privateKey = this.keyParser.parse(keyBytes, keyType);
            this.isInitialized = true;
        }
        catch (KeyParserException e) {
            throw new SignatureEngineException(e);
        }
    }

    @Override
    public byte[] sign(byte[] toBeSigned) throws SignatureEngineException {
        byte[] signature = null;
        if (!this.isInitialized) {
            throw new SignatureEngineException("Signature engine is not initialized!");
        }
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(toBeSigned);
            signature = this.signature.sign();
        }
        catch (InvalidKeyException e) {
            throw new SignatureEngineException(e);
        }
        catch (SignatureException e) {
            throw new SignatureEngineException(e);
        }
        return signature;
    }
}

