"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/ui/public/$1/'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['!**/*.ts', '**/*.tsx', '!**/*.js', '!**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  testEnvironment: 'jsdom',
  testTimeout: 20000
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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