/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.rest.wizard.HttpMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RestFilterPanelVisual
extends JPanel {
    private JLabel headerLbl;
    private JTextField headers;
    private JLabel headersLbl;
    private JTextField methods;
    private JLabel methodsLbl;
    private JTextField origin;
    private JLabel originLbl;
    private JButton selectMethodsBtn;
    private List<HttpMethodsPanel.HttpMethods> httpMethods;

    public RestFilterPanelVisual(WizardDescriptor descriptor) {
        this.initComponents();
        this.httpMethods = new ArrayList<HttpMethodsPanel.HttpMethods>(HttpMethodsPanel.HttpMethods.values().length);
        this.httpMethods.add(HttpMethodsPanel.HttpMethods.OPTIONS);
        this.httpMethods.add(HttpMethodsPanel.HttpMethods.GET);
        this.httpMethods.add(HttpMethodsPanel.HttpMethods.POST);
        this.httpMethods.add(HttpMethodsPanel.HttpMethods.PUT);
        this.httpMethods.add(HttpMethodsPanel.HttpMethods.DELETE);
        this.setMethods();
    }

    void store(WizardDescriptor descriptor) {
        descriptor.putProperty("http-methods", this.httpMethods);
        descriptor.putProperty("origin", (Object)this.origin.getText().trim());
        descriptor.putProperty("headers", (Object)this.headers.getText().trim());
    }

    private void initComponents() {
        this.headerLbl = new JLabel();
        this.originLbl = new JLabel();
        this.origin = new JTextField();
        this.methodsLbl = new JLabel();
        this.methods = new JTextField();
        this.selectMethodsBtn = new JButton();
        this.headersLbl = new JLabel();
        this.headers = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.headerLbl, (String)NbBundle.getMessage(RestFilterPanelVisual.class, (String)"LBL_Headers"));
        this.originLbl.setLabelFor(this.origin);
        Mnemonics.setLocalizedText((JLabel)this.originLbl, (String)NbBundle.getMessage(RestFilterPanelVisual.class, (String)"LBL_Origin"));
        this.origin.setText("*");
        this.methodsLbl.setLabelFor(this.methods);
        Mnemonics.setLocalizedText((JLabel)this.methodsLbl, (String)NbBundle.getMessage(RestFilterPanelVisual.class, (String)"LBL_Methods"));
        this.methods.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.selectMethodsBtn, (String)NbBundle.getMessage(RestFilterPanelVisual.class, (String)"BTN_Methods"));
        this.selectMethodsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RestFilterPanelVisual.this.selectMethods(evt);
            }
        });
        this.headersLbl.setLabelFor(this.headers);
        Mnemonics.setLocalizedText((JLabel)this.headersLbl, (String)NbBundle.getMessage(RestFilterPanelVisual.class, (String)"LBL_AllowHeaders"));
        this.headers.setText("Content-Type");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLbl).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.originLbl).addGap(18, 18, 18).addComponent(this.origin)).addGroup(layout.createSequentialGroup().addComponent(this.methodsLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.methods, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectMethodsBtn, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.headersLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headers)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.originLbl).addComponent(this.origin, -2, -1, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.methodsLbl).addComponent(this.methods, -2, -1, -2).addComponent(this.selectMethodsBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headersLbl).addComponent(this.headers, -2, -1, -2))));
        this.originLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSN_Origin"));
        this.originLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSD_Origin"));
        this.origin.getAccessibleContext().setAccessibleName(this.originLbl.getAccessibleContext().getAccessibleName());
        this.origin.getAccessibleContext().setAccessibleDescription(this.methodsLbl.getAccessibleContext().getAccessibleDescription());
        this.methodsLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"LBL_AllowMethods"));
        this.methodsLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSD_AllowMethods"));
        this.methods.getAccessibleContext().setAccessibleName(this.methodsLbl.getAccessibleContext().getAccessibleName());
        this.methods.getAccessibleContext().setAccessibleDescription(this.methodsLbl.getAccessibleContext().getAccessibleDescription());
        this.selectMethodsBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSN_SelectMethods"));
        this.selectMethodsBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSD_SelectMethods"));
        this.headersLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSN_AllowHeaders"));
        this.headersLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestFilterPanelVisual.class, (String)"ACSD_AllowHeaders"));
        this.headers.getAccessibleContext().setAccessibleName(this.headerLbl.getAccessibleContext().getAccessibleName());
        this.headers.getAccessibleContext().setAccessibleDescription(this.headerLbl.getAccessibleContext().getAccessibleDescription());
    }

    private void selectMethods(ActionEvent evt) {
        HttpMethodsPanel panel = new HttpMethodsPanel(this.httpMethods);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(HttpMethodsPanel.class, (String)"TTL_HttpMethods"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            this.httpMethods = panel.getSelectedMethods();
            this.setMethods();
        }
    }

    private void setMethods() {
        StringBuilder builder = new StringBuilder();
        for (HttpMethodsPanel.HttpMethods method : this.httpMethods) {
            builder.append(method.toString().toUpperCase());
            builder.append(", ");
        }
        if (builder.length() > 0) {
            this.methods.setText(builder.substring(0, builder.length() - 2));
        }
    }
}

