/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.json.parser.JsonBaseVisitor;
import org.netbeans.modules.javascript2.json.parser.JsonLexer;
import org.netbeans.modules.javascript2.json.parser.JsonParser;
import org.netbeans.modules.javascript2.json.parser.ParseTreeToXml;
import org.netbeans.modules.javascript2.model.JsArrayImpl;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.ModelBuilder;
import org.netbeans.modules.javascript2.model.ModelResolver;
import org.netbeans.modules.javascript2.model.OccurrenceBuilder;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.w3c.dom.Document;

public final class JsonModelResolver
extends JsonBaseVisitor<Boolean>
implements ModelResolver {
    private static final Logger LOG = Logger.getLogger(JsonModelResolver.class.getName());
    private final org.netbeans.modules.javascript2.types.spi.ParserResult parserResult;
    private final ModelBuilder modelBuilder;
    private final Deque<Pair<ParserRuleContext, JsObject>> path = new ArrayDeque<Pair<ParserRuleContext, JsObject>>();
    private boolean importantTerminalExpected;

    private JsonModelResolver(@NonNull org.netbeans.modules.javascript2.types.spi.ParserResult parserResult, @NonNull OccurrenceBuilder occurrenceBuilder) {
        Parameters.notNull((CharSequence)"parserResult", (Object)parserResult);
        Parameters.notNull((CharSequence)"occurrenceBuilder", (Object)occurrenceBuilder);
        this.parserResult = parserResult;
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        this.modelBuilder = new ModelBuilder(JsFunctionImpl.createGlobal(fileObject, Integer.MAX_VALUE, parserResult.getSnapshot().getMimeType()));
    }

    @Override
    public void init() {
        JsonParser.JsonContext parseTree = (JsonParser.JsonContext)this.parserResult.getLookup().lookup(JsonParser.JsonContext.class);
        if (LOG.isLoggable(Level.FINEST)) {
            FileObject file = this.parserResult.getSnapshot().getSource().getFileObject();
            if (parseTree != null) {
                try {
                    JsonLexer l = new JsonLexer((CharStream)new ANTLRInputStream());
                    ParseTreeToXml visitor = new ParseTreeToXml(l, new JsonParser((TokenStream)new CommonTokenStream((TokenSource)l)));
                    LOG.log(Level.FINEST, "Parse tree for file: {0}\n{1}", new Object[]{file == null ? null : FileUtil.getFileDisplayName((FileObject)file), ParseTreeToXml.stringify((Document)((Document)visitor.visit((ParseTree)parseTree)))});
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINEST, "Error dumping parse tree for file: {0} : {1}", new Object[]{file == null ? null : FileUtil.getFileDisplayName((FileObject)file), ioe.getMessage()});
                }
            } else {
                LOG.log(Level.FINEST, "No parse tree for file: {0}", file == null ? null : FileUtil.getFileDisplayName((FileObject)file));
            }
        }
        if (parseTree != null) {
            parseTree.accept((ParseTreeVisitor)this);
        }
    }

    @Override
    public JsObject getGlobalObject() {
        return this.modelBuilder.getGlobal();
    }

    @Override
    public JsObject resolveThis(JsObject where) {
        return where;
    }

    @Override
    public void processCalls(ModelElementFactory elementFactory, Map<String, Map<Integer, List<TypeUsage>>> returnTypesFromFrameworks) {
    }

    @Override
    public List<Identifier> getASTNodeName(Object astNode) {
        return Collections.emptyList();
    }

    public Boolean visitObject(JsonParser.ObjectContext ctx) {
        JsObjectImpl object = null;
        if (!this.path.isEmpty()) {
            Pair<ParserRuleContext, JsObject> top = this.path.peek();
            if (top.first() instanceof JsonParser.PairContext) {
                object = this.createJSObject(ctx, (JsonParser.PairContext)top.first());
            } else if (top.first() instanceof JsonParser.ArrayContext) {
                object = this.createJSObject(ctx, null);
                ((JsArrayImpl)top.second()).addTypeInArray(new TypeUsage(object.getFullyQualifiedName(), ctx.start.getStartIndex()));
            }
        }
        if (object == null) {
            object = this.createJSObject(ctx, null);
        }
        this.modelBuilder.setCurrentObject(object);
        this.path.push((Pair<ParserRuleContext, JsObject>)Pair.of((Object)ctx, (Object)object));
        super.visitObject(ctx);
        this.path.pop();
        this.modelBuilder.reset();
        return true;
    }

    public Boolean visitArray(JsonParser.ArrayContext ctx) {
        JsArrayImpl object = null;
        if (!this.path.isEmpty()) {
            Pair<ParserRuleContext, JsObject> top = this.path.peek();
            if (top.first() instanceof JsonParser.PairContext) {
                object = this.createJsArray(ctx, (JsonParser.PairContext)top.first());
            } else if (top.first() instanceof JsonParser.ArrayContext) {
                object = this.createJsArray(ctx, null);
                ((JsArrayImpl)top.second()).addTypeInArray(new TypeUsage(object.getFullyQualifiedName(), ctx.start.getStartIndex()));
            }
        }
        if (object == null) {
            object = this.createJsArray(ctx, null);
        }
        this.modelBuilder.setCurrentObject(object);
        this.path.push((Pair<ParserRuleContext, JsObject>)Pair.of((Object)ctx, (Object)object));
        super.visitArray(ctx);
        this.path.pop();
        this.modelBuilder.reset();
        return true;
    }

    public Boolean visitTerminal(TerminalNode node) {
        if (!this.importantTerminalExpected) {
            return false;
        }
        if (!this.path.isEmpty()) {
            Pair<ParserRuleContext, JsObject> top = this.path.peek();
            if (top.first() instanceof JsonParser.PairContext) {
                this.createJSObject(node, (JsonParser.PairContext)top.first());
            } else if (top.first() instanceof JsonParser.ArrayContext) {
                ((JsArrayImpl)top.second()).addTypeInArray(JsonModelResolver.getLiteralType(node));
            }
        } else {
            this.createJSObject(node, null);
        }
        super.visitTerminal(node);
        return true;
    }

    public Boolean visitValue(JsonParser.ValueContext ctx) {
        this.importantTerminalExpected = JsonModelResolver.hasImportantTerminal(ctx);
        Boolean res = (Boolean)super.visitValue(ctx);
        this.importantTerminalExpected = false;
        return res;
    }

    public Boolean visitPair(JsonParser.PairContext ctx) {
        this.path.push((Pair<ParserRuleContext, JsObject>)Pair.of((Object)ctx, null));
        super.visitPair(ctx);
        this.path.pop();
        return true;
    }

    @NonNull
    private JsObjectImpl createJSObject(@NonNull JsonParser.ObjectContext objLit, @NullAllowed JsonParser.PairContext property) {
        JsObjectImpl declarationScope = this.modelBuilder.getCurrentObject();
        Identifier name = property != null ? new Identifier(this.stringValue(property.key().getText()), JsonModelResolver.createOffsetRange((ParserRuleContext)property.key())) : new Identifier(this.modelBuilder.getUnigueNameForAnonymObject((ParserResult)this.parserResult), OffsetRange.NONE);
        JsObjectImpl object = new JsObjectImpl(declarationScope, name, JsonModelResolver.createOffsetRange((ParserRuleContext)(property != null ? property : objLit)), true, declarationScope.getMimeType(), declarationScope.getSourceLabel());
        declarationScope.addProperty(object.getName(), object);
        object.setJsKind(JsElement.Kind.OBJECT_LITERAL);
        if (property == null) {
            object.setAnonymous(true);
        } else {
            object.addOccurrence(name.getOffsetRange());
        }
        return object;
    }

    @NonNull
    private JsObjectImpl createJSObject(@NonNull TerminalNode literal, @NullAllowed JsonParser.PairContext property) {
        JsObjectImpl declarationScope = this.modelBuilder.getCurrentObject();
        Identifier name = property != null ? new Identifier(this.stringValue(property.key().getText()), JsonModelResolver.createOffsetRange((ParserRuleContext)property.key())) : new Identifier(this.modelBuilder.getUnigueNameForAnonymObject((ParserResult)this.parserResult), OffsetRange.NONE);
        JsObjectImpl object = new JsObjectImpl(declarationScope, name, property != null ? JsonModelResolver.createOffsetRange((ParserRuleContext)property) : JsonModelResolver.createOffsetRange(literal), true, declarationScope.getMimeType(), declarationScope.getSourceLabel());
        declarationScope.addProperty(object.getName(), object);
        object.addAssignment(JsonModelResolver.getLiteralType(literal), object.getOffset());
        if (property == null) {
            object.setAnonymous(true);
            object.setJsKind(JsElement.Kind.OBJECT);
        } else {
            object.setJsKind(JsElement.Kind.PROPERTY);
            object.addOccurrence(name.getOffsetRange());
        }
        return object;
    }

    @NonNull
    private JsArrayImpl createJsArray(@NonNull JsonParser.ArrayContext arrayLit, @NullAllowed JsonParser.PairContext property) {
        JsObjectImpl declarationScope = this.modelBuilder.getCurrentObject();
        Identifier name = property != null ? new Identifier(this.stringValue(property.key().getText()), JsonModelResolver.createOffsetRange((ParserRuleContext)property.key())) : new Identifier(this.modelBuilder.getUnigueNameForAnonymObject((ParserResult)this.parserResult), OffsetRange.NONE);
        JsArrayImpl array = new JsArrayImpl(declarationScope, name, JsonModelResolver.createOffsetRange((ParserRuleContext)(property != null ? property : arrayLit)), declarationScope.getMimeType(), declarationScope.getSourceLabel());
        declarationScope.addProperty(array.getName(), array);
        array.addAssignment(new TypeUsage("Array", -1, true), array.getOffset());
        array.setDeclared(true);
        if (property == null) {
            array.setAnonymous(true);
            array.setJsKind(JsElement.Kind.OBJECT_LITERAL);
        } else {
            array.setJsKind(JsElement.Kind.PROPERTY);
            array.addOccurrence(name.getOffsetRange());
        }
        return array;
    }

    @NonNull
    private static OffsetRange createOffsetRange(@NonNull ParserRuleContext parseTree) {
        int start = parseTree.start.getStartIndex();
        int end = parseTree.stop.getStopIndex() + 1;
        if (end <= start) {
            end = start + 1;
            LOG.log(Level.FINE, "ParseTree.start offset is bigger then end offset [{0}, {1}]", new Object[]{parseTree.start.getStartIndex(), parseTree.stop.getStopIndex()});
        }
        return new OffsetRange(start, end);
    }

    @NonNull
    private static OffsetRange createOffsetRange(@NonNull TerminalNode terminal) {
        return new OffsetRange(terminal.getSymbol().getStartIndex(), terminal.getSymbol().getStopIndex() + 1);
    }

    @NonNull
    private String stringValue(@NonNull String strTknVal) {
        return strTknVal.substring(1, strTknVal.length() - 1);
    }

    private static boolean hasImportantTerminal(@NonNull JsonParser.ValueContext valCtx) {
        return valCtx.array() == null && valCtx.object() == null;
    }

    private static TypeUsage getLiteralType(@NonNull TerminalNode t) {
        switch (t.getSymbol().getType()) {
            case 10: 
            case 11: {
                return new TypeUsage("Boolean", -1, true);
            }
            case 13: {
                return new TypeUsage("Number", -1, true);
            }
            case 14: {
                return new TypeUsage("String", -1, true);
            }
            case 12: {
                return new TypeUsage("Object", -1, true);
            }
        }
        throw new IllegalArgumentException(t.toString());
    }

    public static final class Provider
    implements ModelResolver.Provider {
        @Override
        @CheckForNull
        public ModelResolver create(@NonNull org.netbeans.modules.javascript2.types.spi.ParserResult result, @NonNull OccurrenceBuilder occurrenceBuilder) {
            JsonParser.JsonContext parseTree = (JsonParser.JsonContext)result.getLookup().lookup(JsonParser.JsonContext.class);
            if (parseTree == null) {
                return null;
            }
            return new JsonModelResolver(result, occurrenceBuilder);
        }
    }
}

