/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public abstract class CreateRegExpNode
extends JavaScriptBaseNode {
    @Node.Child
    private TRegexUtil.InteropReadMemberNode readNamedCG = TRegexUtil.InteropReadMemberNode.create();
    @Node.Child
    private TRegexUtil.InteropIsNullNode isNamedCGNull = TRegexUtil.InteropIsNullNode.create();
    @Node.Child
    private PropertySetNode setLastIndex;
    private final JSContext context;

    protected CreateRegExpNode(JSContext context) {
        this.context = context;
        this.setLastIndex = PropertySetNode.createImpl("lastIndex", false, context, true, true, JSAttributes.notConfigurableNotEnumerableWritable());
    }

    public static CreateRegExpNode create(JSContext context) {
        return CreateRegExpNodeGen.create(context);
    }

    public DynamicObject createRegExp(Object compiledRegex) {
        return this.createRegExp(compiledRegex, true);
    }

    public DynamicObject createRegExp(Object compiledRegex, boolean legacyFeaturesEnabled) {
        return this.execute(compiledRegex, legacyFeaturesEnabled);
    }

    protected abstract DynamicObject execute(Object var1, boolean var2);

    @Specialization(guards={"!hasNamedCG(compiledRegex)"})
    protected DynamicObject createWithoutNamedCG(Object compiledRegex, boolean legacyFeaturesEnabled) {
        DynamicObject reObj = JSRegExp.create(this.context, compiledRegex, null, legacyFeaturesEnabled);
        this.setLastIndex.setValueInt(reObj, 0);
        return reObj;
    }

    @Specialization(guards={"hasNamedCG(compiledRegex)"})
    protected DynamicObject createWithNamedCG(Object compiledRegex, boolean legacyFeaturesEnabled) {
        Object namedCaptureGroups = this.readNamedCG.execute(compiledRegex, "groups");
        DynamicObject reObj = JSRegExp.create(this.context, compiledRegex, JSRegExp.buildGroupsFactory(this.context, namedCaptureGroups), legacyFeaturesEnabled);
        this.setLastIndex.setValueInt(reObj, 0);
        return reObj;
    }

    protected boolean hasNamedCG(Object compiledRegex) {
        Object namedCaptureGroups = this.readNamedCG.execute(compiledRegex, "groups");
        return !this.isNamedCGNull.execute(namedCaptureGroups);
    }
}

