/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.SiteDocsNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class SiteDocsNodeFactory
implements NodeFactory {
    private static final String KEY_SITE = "SITE";

    public NodeList createNodes(Project project) {
        NbMavenProjectImpl prj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(prj);
    }

    private static class NList
    extends AbstractMavenNodeList<String>
    implements FileChangeListener,
    PropertyChangeListener {
        private final NbMavenProjectImpl project;

        private NList(NbMavenProjectImpl prj) {
            this.project = prj;
        }

        public List<String> keys() {
            FileObject fo = FileUtil.toFileObject((File)Utilities.toFile((URI)this.project.getSiteDirectory()));
            if (fo != null && fo.isValid()) {
                return Collections.singletonList(SiteDocsNodeFactory.KEY_SITE);
            }
            return Collections.emptyList();
        }

        public Node node(String key) {
            return this.createSiteDocsNode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.fireChange();
            }
        }

        @Override
        public void addNotify() {
            NbMavenProject.addPropertyChangeListener(this.project, this);
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)Utilities.toFile((URI)this.project.getSiteDirectory()));
        }

        @Override
        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener(this.project, this);
        }

        private Node createSiteDocsNode() {
            DataFolder fold;
            SiteDocsNode n = null;
            FileObject fo = FileUtil.toFileObject((File)Utilities.toFile((URI)this.project.getSiteDirectory()));
            if (fo != null && (fold = DataFolder.findFolder((FileObject)fo)) != null) {
                n = new SiteDocsNode(this.project, fold.getNodeDelegate().cloneNode());
            }
            return n;
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

