/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public final class DelayedDocumentChangeListener
implements DocumentListener {
    private Document doc;
    private Timer changeTimer;
    private ChangeEvent chEvt;

    public static DocumentListener create(Document doc, ChangeListener l, int delay) {
        return new DelayedDocumentChangeListener(doc, l, delay);
    }

    private DelayedDocumentChangeListener(Document doc, final ChangeListener l, int delay) {
        this.doc = doc;
        this.doc.addDocumentListener(this);
        this.chEvt = new ChangeEvent(doc);
        this.changeTimer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.stateChanged(DelayedDocumentChangeListener.this.chEvt);
            }
        });
        this.changeTimer.setRepeats(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.maybeChange(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.maybeChange(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.maybeChange(e);
    }

    private void maybeChange(DocumentEvent e) {
        this.changeTimer.restart();
    }
}

