/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentedCodeBlock
extends Block
implements TextContainer {
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public IndentedCodeBlock() {
    }

    public IndentedCodeBlock(BasedSequence chars) {
        super(chars);
    }

    public IndentedCodeBlock(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public IndentedCodeBlock(BlockContent blockContent) {
        super(blockContent);
    }

    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        BasedSequence chars = this.getContentChars();
        if (BitFieldSet.any((long)flags, (long)F_NODE_TEXT)) {
            out.append((CharSequence)chars);
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(chars);
            BasedSequence unescaped = Escaping.unescape((BasedSequence)chars, (ReplacedTextMapper)textMapper);
            if (!unescaped.isEmpty()) {
                out.append((CharSequence)unescaped);
            }
        }
        return false;
    }
}

