/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;

@ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
final class DefaultLanguageView<C>
implements TruffleObject {
    private final TruffleLanguage<C> language;
    private final C context;
    protected final Object delegate;
    protected final Object unwrapped;

    DefaultLanguageView(TruffleLanguage<C> language, C context, Object delegate) {
        this.language = language;
        this.context = context;
        this.delegate = delegate;
        this.unwrapped = EngineAccessor.INTEROP.unwrapLegacyMetaObjectWrapper(delegate);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasSourceLocation(@CachedLibrary(value="this.delegate") InteropLibrary delegateLib) {
        return EngineAccessor.LANGUAGE.legacyFindSourceLocation(this.language, this.context, this.unwrapped) != null || delegateLib.hasSourceLocation(this.delegate);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation(@CachedLibrary(value="this.delegate") InteropLibrary delegateLib) throws UnsupportedMessageException {
        SourceSection location = EngineAccessor.LANGUAGE.legacyFindSourceLocation(this.language, this.context, this.unwrapped);
        if (location != null) {
            return location;
        }
        return delegateLib.getSourceLocation(this.delegate);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean config) {
        String result = EngineAccessor.LANGUAGE.legacyToString(this.language, this.context, this.unwrapped);
        return result;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return this.language.getClass();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasMetaObject() {
        return EngineAccessor.LANGUAGE.legacyFindMetaObject(this.language, this.context, this.unwrapped) != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaObject() throws UnsupportedMessageException {
        Object result = EngineAccessor.LANGUAGE.legacyFindMetaObject(this.language, this.context, this.unwrapped);
        if (result != null) {
            return EngineAccessor.INTEROP.createLegacyMetaObjectWrapper(this, result);
        }
        throw UnsupportedMessageException.create();
    }
}

