/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.api.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class GradleReport {
    private final String errorClass;
    private final String location;
    private final int line;
    private final String message;
    private final GradleReport causedBy;

    GradleReport(String errorClass, String location, int line, String message, GradleReport causedBy) {
        this.errorClass = errorClass;
        this.location = location;
        this.line = line;
        this.message = message == null ? "" : message;
        this.causedBy = causedBy;
    }

    @CheckForNull
    public String getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.line;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @CheckForNull
    public GradleReport getCause() {
        return this.causedBy;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradleReport other = (GradleReport)obj;
        if (!Objects.equals(this.errorClass, other.errorClass)) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        return Objects.equals(this.location, other.location);
    }

    public String toString() {
        return this.formatReportForHintOrProblem(true, null);
    }

    public String formatReportForHintOrProblem(boolean includeLocation, FileObject relativeTo) {
        String locString;
        String msg = "";
        String prevMessage = null;
        for (GradleReport r2 = this; !(r2 == null || prevMessage != null && prevMessage.contains(r2.getMessage())); r2 = r2.getCause()) {
            prevMessage = r2.getMessage();
            msg = Bundle.FMT_AppendMessage(msg, r2.getMessage());
        }
        if (!includeLocation || this.getLocation() == null) {
            return msg;
        }
        if (relativeTo != null) {
            File dir = FileUtil.toFile((FileObject)relativeTo);
            try {
                Path scriptPath = Paths.get(this.getLocation(), new String[0]);
                locString = dir.toPath().relativize(scriptPath).toString();
            }
            catch (IllegalArgumentException | FileSystemNotFoundException ex) {
                locString = this.getLocation();
            }
        } else {
            locString = this.getLocation();
        }
        if (this.getLine() >= 1) {
            return Bundle.FMT_MessageWithLocation(msg, locString, this.getLine());
        }
        return Bundle.FMT_MessageWithLocationNoLine(msg, locString);
    }
}

