/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.api.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PlatformChooserVisualPanel
extends BasicVisualPanel
implements PropertyChangeListener {
    private Box.Filler filler;
    private JPanel infoPanel;
    private JLabel plafLabel;
    private JTextField plafLabelValue;
    private JLabel plafName;
    private JTextField plafNameValue;
    private JFileChooser platformChooser;
    private static final Pattern LABEL_PATTERN = Pattern.compile("NetBeans (?:Platform|IDE) (Dev|[0-9.]+)(?: [(]Build .+[)])?");

    public PlatformChooserVisualPanel(WizardDescriptor setting) {
        super(setting);
        this.initComponents();
        this.initAccessibility();
        String location = ModuleUISettings.getDefault().getLastUsedNbPlatformLocation();
        if (location != null) {
            File curDir = new File(location);
            if (curDir.equals(this.platformChooser.getCurrentDirectory()) && null != curDir.getParentFile()) {
                this.platformChooser.setCurrentDirectory(curDir.getParentFile());
            }
            this.platformChooser.setCurrentDirectory(curDir);
        }
        this.platformChooser.setAcceptAllFileFilterUsed(false);
        this.platformChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return PlatformChooserVisualPanel.getMessage("CTL_PlatformFolder");
            }
        });
        this.platformChooser.addPropertyChangeListener(this);
        this.setName(NbPlatformCustomizer.CHOOSER_STEP);
        this.platformChooser.putClientProperty("JFileChooser.appBundleIsTraversable", "always");
    }

    public void addNotify() {
        super.addNotify();
        this.checkForm();
    }

    void storeData() {
        File file = this.platformChooser.getSelectedFile();
        if (file != null) {
            this.getSettings().putProperty("selectedPlafDir", (Object)file.getAbsolutePath());
            this.getSettings().putProperty("selectedPlafLabel", (Object)this.plafNameValue.getText());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("SelectedFileChangedProperty")) {
            this.checkForm();
        }
    }

    private void checkForm() {
        File plafDir;
        File selFile = this.platformChooser.getSelectedFile();
        boolean invalid = true;
        if (selFile != null && NbPlatform.isPlatformDirectory(plafDir = FileUtil.normalizeFile((File)selFile))) {
            try {
                this.setPlafLabel(PlatformChooserVisualPanel.cleanupLabel(NbPlatform.computeDisplayName(plafDir)));
            }
            catch (IOException e) {
                this.setPlafLabel(plafDir.getAbsolutePath());
            }
            this.plafLabelValue.setText(NbPlatform.getComputedLabel(plafDir));
            this.plafLabelValue.setCaretPosition(0);
            if (!NbPlatform.isSupportedPlatform(plafDir)) {
                this.setError(PlatformChooserVisualPanel.getMessage("MSG_UnsupportedPlatform"));
            } else if (NbPlatform.contains(plafDir)) {
                this.setError(PlatformChooserVisualPanel.getMessage("MSG_AlreadyAddedPlatform"));
            } else if (!NbPlatform.isLabelValid(this.plafNameValue.getText())) {
                this.setWarning(PlatformChooserVisualPanel.getMessage("MSG_NameIsAlreadyUsedGoToNext"));
            } else {
                this.markValid();
                ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(plafDir.getParentFile().getAbsolutePath());
            }
            invalid = false;
        }
        if (invalid) {
            this.markInvalid();
            this.setPlafLabel(null);
            this.plafLabelValue.setText(null);
            this.storeData();
        }
    }

    private void setPlafLabel(String label) {
        this.plafNameValue.setText(label);
        this.plafNameValue.setCaretPosition(0);
        this.storeData();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(PlatformChooserVisualPanel.class, (String)key);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.plafLabel = new JLabel();
        this.plafLabelValue = new JTextField();
        this.plafName = new JLabel();
        this.plafNameValue = new JTextField();
        this.filler = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.platformChooser = new JFileChooser();
        GridBagLayout infoPanelLayout = new GridBagLayout();
        infoPanelLayout.columnWidths = new int[]{0};
        infoPanelLayout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0};
        this.infoPanel.setLayout(infoPanelLayout);
        this.plafLabel.setLabelFor(this.plafLabelValue);
        Mnemonics.setLocalizedText((JLabel)this.plafLabel, (String)NbBundle.getMessage(PlatformChooserVisualPanel.class, (String)"LBL_PlatformName_N"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.infoPanel.add((Component)this.plafLabel, gridBagConstraints);
        this.plafLabelValue.setColumns(15);
        this.plafLabelValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.infoPanel.add((Component)this.plafLabelValue, gridBagConstraints);
        this.plafName.setLabelFor(this.plafNameValue);
        Mnemonics.setLocalizedText((JLabel)this.plafName, (String)NbBundle.getMessage(PlatformChooserVisualPanel.class, (String)"LBL_PlatformName_P"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.infoPanel.add((Component)this.plafName, gridBagConstraints);
        this.plafNameValue.setColumns(15);
        this.plafNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.infoPanel.add((Component)this.plafNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.filler, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.platformChooser.setAccessory(this.infoPanel);
        this.platformChooser.setControlButtonsAreShown(false);
        this.platformChooser.setFileSelectionMode(1);
        this.add(this.platformChooser, "Center");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_PlatformChooserVisualPanel"));
        this.plafNameValue.getAccessibleContext().setAccessibleDescription(PlatformChooserVisualPanel.getMessage("ACS_CTL_plafLabelValue"));
    }

    static String cleanupLabel(String label) {
        Matcher m = LABEL_PATTERN.matcher(label);
        if (m.matches()) {
            String v1 = m.group(1);
            String v2 = v1.equals("Dev") ? "dev" : v1.replace(".", "");
            return "nb" + v2;
        }
        return label;
    }
}

