/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.charset.CharMatchers;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;

public final class TRegexLiteralLookAroundExecutorNode
extends TRegexExecutorNode {
    private final boolean forward;
    private final boolean negated;
    @Node.Children
    private CharMatcher[] matchers;

    public TRegexLiteralLookAroundExecutorNode(LookAroundAssertion lookAround, CompilationBuffer compilationBuffer) {
        assert (lookAround.isLiteral());
        this.forward = lookAround.isLookAheadAssertion();
        this.negated = lookAround.isNegated();
        this.matchers = new CharMatcher[lookAround.getLiteralLength()];
        for (int i = 0; i < this.matchers.length; ++i) {
            CharMatcher matcher = CharMatchers.createMatcher(lookAround.getGroup().getFirstAlternative().get(i).asCharacterClass().getCharSet(), compilationBuffer);
            this.matchers[this.forward ? i : this.matchers.length - (i + 1)] = (CharMatcher)this.insert(matcher);
        }
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    @Override
    public boolean writesCaptureGroups() {
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    @ExplodeLoop
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        for (int i = 0; i < this.matchers.length; ++i) {
            if (!this.inputHasNext(locals) || !this.matchers[i].execute(this.inputReadAndDecode(locals))) {
                return this.negated;
            }
            this.inputAdvance(locals);
        }
        return !this.negated;
    }
}

