/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.filesystems.FileUtil;

public class NBModelBuilder
extends DefaultModelBuilder {
    private static final String NETBEANS_PROFILES = "____netbeans.profiles";
    private static final String NETBEANS_MODELDESCS = "____netbeans.model.descriptions";

    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        ModelBuildingResult toRet = super.build(request);
        this.postProcessResult(request, toRet);
        Model eff = toRet.getEffectiveModel();
        InputSource source = new InputSource();
        source.setLocation("");
        InputLocation location = new InputLocation(-1, -1, source);
        eff.setLocation((Object)NETBEANS_PROFILES, location);
        for (String id : toRet.getModelIds()) {
            Model mdl = toRet.getRawModel(id);
            for (Profile p : mdl.getProfiles()) {
                source.setLocation(source.getLocation() + "|" + p.getId());
            }
        }
        return toRet;
    }

    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        ModelBuildingResult mbr = super.build(request, result);
        this.postProcessResult(request, result);
        return mbr;
    }

    private void postProcessResult(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        if (request.getPomFile() != null && result.getEffectiveModel().getLocation((Object)NETBEANS_MODELDESCS) == null) {
            ArrayList<MavenEmbedder.ModelDescription> rawModels = new ArrayList<MavenEmbedder.ModelDescription>();
            for (String id : result.getModelIds()) {
                if (id == null || id.trim().length() <= 0) continue;
                Model m = result.getRawModel(id);
                ArrayList<String> modules = new ArrayList<String>();
                for (String module : m.getModules()) {
                    modules.add(module);
                }
                String name = m.getName();
                ArrayList<String> profiles = new ArrayList<String>();
                for (Profile p : m.getProfiles()) {
                    profiles.add(p.getId());
                    if (!request.getActiveProfileIds().contains(p.getId())) continue;
                    for (String module : p.getModules()) {
                        if (modules.contains(module)) continue;
                        modules.add(module);
                    }
                }
                File loc = m.getPomFile() != null ? FileUtil.normalizeFile((File)m.getPomFile()) : null;
                rawModels.add(new ModelDescImpl(id, loc, name, profiles, modules));
            }
            result.getEffectiveModel().setLocation((Object)NETBEANS_MODELDESCS, new InputLocation(-1, -1, (InputSource)new ModelInputSource(rawModels)));
        }
    }

    public static Set<String> getAllProfiles(Model mdl) {
        InputLocation location = mdl.getLocation((Object)NETBEANS_PROFILES);
        HashSet<String> toRet = new HashSet<String>();
        if (location != null) {
            String s = location.getSource().getLocation();
            if (!s.isEmpty()) {
                s = s.substring(1);
                toRet.addAll(Arrays.asList(s.split("\\|")));
            }
            return toRet;
        }
        return null;
    }

    public static List<MavenEmbedder.ModelDescription> getModelDescriptors(Model effective) {
        InputLocation loc = effective.getLocation((Object)NETBEANS_MODELDESCS);
        if (loc != null && loc.getSource() instanceof ModelInputSource) {
            ModelInputSource mis = (ModelInputSource)loc.getSource();
            return mis.rawModels;
        }
        return null;
    }

    private static class ModelDescImpl
    implements MavenEmbedder.ModelDescription {
        final String id;
        final String artifactId;
        final String groupId;
        final String version;
        File location;
        final String name;
        final List<String> profileNames;
        final List<String> modules;

        ModelDescImpl(String id, File location, String name, List<String> profileNames, List<String> modules) {
            this.id = id;
            String[] arr = id.split(":");
            assert (arr != null && arr.length == 3);
            this.groupId = arr[0];
            this.artifactId = arr[1];
            this.version = arr[2];
            this.location = location;
            this.name = name;
            this.profileNames = profileNames;
            this.modules = modules;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public File getLocation() {
            if (this.location != null) {
                return this.location;
            }
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            Artifact art = embedder.createProjectArtifact(this.groupId, this.artifactId, this.version);
            File file = new File(embedder.getLocalRepositoryFile(), embedder.getLocalRepository().pathOf(art));
            this.location = FileUtil.normalizeFile((File)file);
            return this.location;
        }

        @Override
        public List<String> getProfiles() {
            return this.profileNames;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public List<String> getModules() {
            return this.modules;
        }
    }

    private static class ModelInputSource
    extends InputSource {
        final List<MavenEmbedder.ModelDescription> rawModels;

        public ModelInputSource(List<MavenEmbedder.ModelDescription> rawModels) {
            this.rawModels = rawModels;
            this.setLocation("");
        }
    }
}

