/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.IOException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleGenerator;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectGenerator;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;

public class PhpModuleGeneratorImpl
implements PhpModuleGenerator {
    public PhpModule createModule(PhpModuleGenerator.CreateProperties properties) throws IOException {
        this.checkProperties(properties);
        AntProjectHelper projectHelper = PhpProjectGenerator.createProject(this.map(properties), null);
        Project project = FileOwnerQuery.getOwner((FileObject)projectHelper.getProjectDirectory());
        assert (project != null);
        PhpProject phpProject = (PhpProject)project.getLookup().lookup(PhpProject.class);
        if (phpProject == null) {
            throw new IllegalStateException("PHP project needed but found " + project.getClass().getName());
        }
        return phpProject.getPhpModule();
    }

    private void checkProperties(PhpModuleGenerator.CreateProperties properties) {
        ValidationResult result = new PhpModuleGenerator.CreatePropertiesValidator().validate(properties).getResult();
        if (result.hasErrors()) {
            throw new IllegalArgumentException(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
        }
        if (result.hasWarnings()) {
            throw new IllegalArgumentException(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
        }
    }

    private PhpProjectGenerator.ProjectProperties map(PhpModuleGenerator.CreateProperties properties) {
        PhpProjectGenerator.ProjectProperties projectProperties = new PhpProjectGenerator.ProjectProperties();
        projectProperties.setName(properties.getName());
        projectProperties.setProjectDirectory(properties.getProjectDirectory());
        projectProperties.setSourcesDirectory(properties.getSourcesDirectory());
        projectProperties.setPhpVersion(properties.getPhpVersion());
        projectProperties.setCharset(properties.getCharset());
        projectProperties.setAutoconfigured(properties.isAutoconfigured());
        projectProperties.setUrl("http://localhost/");
        return projectProperties;
    }
}

