/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.classpath;

import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.java.classpath.SPIAccessor;
import org.openide.util.Parameters;

public abstract class GlobalPathRegistryImplementation {
    private volatile GlobalPathRegistry owner;

    @NonNull
    protected abstract Set<ClassPath> getPaths(@NonNull String var1);

    @NonNull
    protected abstract Set<ClassPath> register(@NonNull String var1, @NonNull ClassPath[] var2);

    @NonNull
    protected abstract Set<ClassPath> unregister(@NonNull String var1, @NonNull ClassPath[] var2) throws IllegalArgumentException;

    @NonNull
    protected abstract Set<ClassPath> clear();

    static {
        SPIAccessor.setInstance(new AccessorImpl());
    }

    private static final class AccessorImpl
    extends SPIAccessor {
        private AccessorImpl() {
        }

        @Override
        @NonNull
        public Set<ClassPath> getPaths(@NonNull GlobalPathRegistryImplementation impl, @NonNull String id) {
            return impl.getPaths(id);
        }

        @Override
        @NonNull
        public Set<ClassPath> register(@NonNull GlobalPathRegistryImplementation impl, @NonNull String id, @NonNull ClassPath[] paths) {
            return impl.register(id, paths);
        }

        @Override
        @NonNull
        public Set<ClassPath> unregister(@NonNull GlobalPathRegistryImplementation impl, @NonNull String id, @NonNull ClassPath[] paths) throws IllegalArgumentException {
            return impl.unregister(id, paths);
        }

        @Override
        @NonNull
        public Set<ClassPath> clear(@NonNull GlobalPathRegistryImplementation impl) {
            return impl.clear();
        }

        @Override
        public void attachAPI(@NonNull GlobalPathRegistryImplementation impl, @NonNull GlobalPathRegistry api) {
            Parameters.notNull((CharSequence)"api", (Object)api);
            impl.owner = api;
        }
    }
}

