/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.Base64SecretContentDetails;
import com.oracle.bmc.vault.model.CreateSecretDetails;
import com.oracle.bmc.vault.model.SecretContentDetails;
import com.oracle.bmc.vault.model.SecretReuseRule;
import com.oracle.bmc.vault.model.UpdateSecretDetails;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.KeyNode;
import org.netbeans.modules.cloud.oracle.vault.SecretItem;
import org.netbeans.modules.cloud.oracle.vault.SecretNode;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.netbeans.modules.cloud.oracle.vault.VaultNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Pair;

public class AddDbConnectionToVault
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AddDbConnectionToVault.class.getName());
    private final DatabaseConnection context;
    static Pattern p = Pattern.compile("[A-Z]*_([A-Z]*)_[A-Z]*");

    public AddDbConnectionToVault(DatabaseConnection context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Multistep multistep = new Multistep(new TenancyStep());
        NotifyDescriptor.ComposedInput ci = new NotifyDescriptor.ComposedInput(Bundle.AddADB(), 3, multistep.createInput());
        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)ci) && multistep.getResult() != null) {
            Result v = (Result)multistep.getResult();
            AddDbConnectionToVault.addDbConnectionToVault(v.vault, v.key, this.context, v.datasourceName);
        }
    }

    private static void addDbConnectionToVault(VaultItem vault, KeyItem key, final DatabaseConnection connection, String datasourceName) {
        VaultsClient client = VaultsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile().getConfigProvider());
        ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).limit(Integer.valueOf(88)).build();
        ListSecretsResponse secrets = client.listSecrets(listSecretsRequest);
        Map<String, String> existingSecrets = secrets.getItems().stream().collect(Collectors.toMap(s -> s.getSecretName(), s -> s.getId()));
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("Username", connection.getUser());
                this.put("Password", connection.getPassword());
                this.put("OCID", (String)connection.getConnectionProperties().get("OCID"));
                this.put("wallet_Password", UUID.randomUUID().toString());
            }
        };
        try {
            for (Map.Entry entry : values.entrySet()) {
                UpdateSecretResponse updateSecretResponse;
                UpdateSecretRequest request;
                String secretName = "DATASOURCES_" + datasourceName + "_" + ((String)entry.getKey()).toUpperCase();
                String base64Content = Base64.getEncoder().encodeToString(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                Base64SecretContentDetails contentDetails = Base64SecretContentDetails.builder().content(base64Content).stage(SecretContentDetails.Stage.Current).build();
                if (existingSecrets.containsKey(secretName)) {
                    UpdateSecretDetails updateSecretDetails = UpdateSecretDetails.builder().secretContent((SecretContentDetails)contentDetails).build();
                    request = UpdateSecretRequest.builder().secretId(existingSecrets.get(secretName)).updateSecretDetails(updateSecretDetails).build();
                    updateSecretResponse = client.updateSecret(request);
                    continue;
                }
                CreateSecretDetails createDetails = CreateSecretDetails.builder().secretName(secretName).secretContent((SecretContentDetails)contentDetails).secretRules(new ArrayList<SecretReuseRule>(Arrays.asList(SecretReuseRule.builder().isEnforcedOnDeletedSecretVersions(Boolean.valueOf(false)).build()))).compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).keyId(key.getKey().getValue()).build();
                request = CreateSecretRequest.builder().createSecretDetails(createDetails).build();
                updateSecretResponse = client.createSecret((CreateSecretRequest)request);
            }
        }
        catch (BmcException e) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)e.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            throw new RuntimeException(e);
        }
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.SecretsCreated());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    private static <T extends OCIItem> NotifyDescriptor.QuickPick createQuickPick(Map<String, T> ociItems, String title) {
        List items = ociItems.entrySet().stream().map(entry -> new NotifyDescriptor.QuickPick.Item((String)entry.getKey(), ((OCIItem)entry.getValue()).getDescription())).collect(Collectors.toList());
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    private static Map<String, OCIItem> getFlatCompartment(TenancyItem tenancy) {
        ListCompartmentsResponse response;
        final HashMap<OCID, FlatCompartmentItem> compartments = new HashMap<OCID, FlatCompartmentItem>();
        OCISessionInitiator session = OCIManager.getDefault().getActiveSession();
        Identity identityClient = session.newClient(IdentityClient.class);
        String nextPageToken = null;
        do {
            response = identityClient.listCompartments(ListCompartmentsRequest.builder().compartmentId(tenancy.getKey().getValue()).compartmentIdInSubtree(true).lifecycleState(Compartment.LifecycleState.Active).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).limit(1000).page(nextPageToken).build());
            for (Compartment comp : response.getItems()) {
                FlatCompartmentItem ci = new FlatCompartmentItem(comp){

                    @Override
                    FlatCompartmentItem getItem(OCID compId) {
                        return (FlatCompartmentItem)compartments.get(compId);
                    }
                };
                compartments.put(ci.getKey(), ci);
            }
        } while ((nextPageToken = response.getOpcNextPage()) != null);
        Map<String, OCIItem> pickItems = AddDbConnectionToVault.computeFlatNames(compartments);
        pickItems.put(tenancy.getName() + " (root)", tenancy);
        return pickItems;
    }

    private static Map<String, OCIItem> computeFlatNames(Map<OCID, FlatCompartmentItem> compartments) {
        TreeMap<String, OCIItem> pickItems = new TreeMap<String, OCIItem>(String.CASE_INSENSITIVE_ORDER);
        for (FlatCompartmentItem comp : compartments.values()) {
            pickItems.put(comp.getName(), comp);
        }
        return pickItems;
    }

    protected static Map<String, VaultItem> getVaults(OCIItem parent) {
        HashMap<String, VaultItem> items = new HashMap<String, VaultItem>();
        try {
            if (parent instanceof CompartmentItem) {
                VaultNode.getVaults().apply((CompartmentItem)parent).forEach(db -> items.put(db.getName(), (VaultItem)db));
            }
        }
        catch (BmcException e) {
            LOG.log(Level.SEVERE, "Unable to load vault list", e);
        }
        return items;
    }

    protected static Map<String, KeyItem> getKeys(OCIItem parent) {
        HashMap<String, KeyItem> items = new HashMap<String, KeyItem>();
        try {
            if (parent instanceof VaultItem) {
                KeyNode.getKeys().apply((VaultItem)parent).forEach(db -> items.put(db.getName(), (KeyItem)db));
            }
        }
        catch (BmcException e) {
            LOG.log(Level.SEVERE, "Unable to load vault list", e);
        }
        return items;
    }

    protected static String extractDatasourceName(String value) {
        Matcher m = p.matcher(value);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private static abstract class FlatCompartmentItem
    extends CompartmentItem {
        private final OCID parentId;
        private String flatName;

        private FlatCompartmentItem(Compartment ociComp) {
            super(OCID.of(ociComp.getId(), "Compartment"), ociComp.getName());
            this.setDescription(ociComp.getDescription());
            this.parentId = OCID.of(ociComp.getCompartmentId(), "Compartment");
        }

        @Override
        public String getName() {
            if (this.parentId.getValue() == null) {
                return "";
            }
            if (this.flatName == null) {
                String parentFlatName = "";
                FlatCompartmentItem parentComp = this.getItem(this.parentId);
                if (parentComp != null) {
                    parentFlatName = parentComp.getName();
                }
                this.flatName = super.getName();
                if (!parentFlatName.isEmpty()) {
                    this.flatName = parentFlatName + "/" + this.flatName;
                }
            }
            return this.flatName;
        }

        abstract FlatCompartmentItem getItem(OCID var1);
    }

    static class Multistep {
        private final LinkedList<Step> steps = new LinkedList();

        Multistep(Step firstStep) {
            this.steps.add(firstStep);
        }

        NotifyDescriptor.ComposedInput.Callback createInput() {
            return new NotifyDescriptor.ComposedInput.Callback(){

                private void showInput(Step step, NotifyDescriptor desc) {
                    String selected = null;
                    if (!step.onlyOneChoice()) {
                        if (desc instanceof NotifyDescriptor.QuickPick) {
                            for (NotifyDescriptor.QuickPick.Item item : ((NotifyDescriptor.QuickPick)desc).getItems()) {
                                if (!item.isSelected()) continue;
                                selected = item.getLabel();
                                break;
                            }
                        } else if (desc instanceof NotifyDescriptor.InputLine) {
                            selected = ((NotifyDescriptor.InputLine)desc).getInputText();
                        }
                        step.setValue(selected);
                    }
                }

                NotifyDescriptor prepareInput(NotifyDescriptor.ComposedInput input, int number) {
                    if (number == 1) {
                        ((Step)steps.get(0)).prepare(null);
                        return ((Step)steps.get(0)).createInput();
                    }
                    if (steps.size() > number) {
                        steps.removeLast();
                        return ((Step)steps.getLast()).createInput();
                    }
                    this.showInput((Step)steps.getLast(), input.getInputs()[number - 2]);
                    Step currentStep = ((Step)steps.getLast()).getNext();
                    if (currentStep == null) {
                        return null;
                    }
                    steps.add(currentStep);
                    if (currentStep.onlyOneChoice()) {
                        return this.prepareInput(input, number);
                    }
                    return currentStep.createInput();
                }

                public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                    return this.prepareInput(input, number);
                }
            };
        }

        Object getResult() {
            return this.steps.getLast().getValue();
        }
    }

    static class Result {
        VaultItem vault;
        KeyItem key;
        String datasourceName;
        private boolean update;

        Result() {
        }
    }

    static class OverwriteStep
    implements Step<Result, Result> {
        private Result result;
        private Set<String> dsNames;
        private String choice;

        OverwriteStep() {
        }

        @Override
        public Step<Result, Result> prepare(Result result) {
            this.result = result;
            List<SecretItem> secrets = SecretNode.getSecrets().apply(result.vault);
            this.dsNames = secrets.stream().map(s -> AddDbConnectionToVault.extractDatasourceName(s.getName())).filter(Objects::nonNull).collect(Collectors.toSet());
            return this;
        }

        @Override
        public NotifyDescriptor createInput() {
            ArrayList<NotifyDescriptor.QuickPick.Item> yesNo = new ArrayList<NotifyDescriptor.QuickPick.Item>();
            yesNo.add(new NotifyDescriptor.QuickPick.Item(Bundle.AddVersion(), ""));
            yesNo.add(new NotifyDescriptor.QuickPick.Item(Bundle.Cancel(), ""));
            return new NotifyDescriptor.QuickPick("", Bundle.SecretExists(this.result.datasourceName), yesNo, false);
        }

        @Override
        public Step getNext() {
            return null;
        }

        @Override
        public void setValue(String choice) {
            this.choice = choice;
        }

        @Override
        public Result getValue() {
            if (Bundle.AddVersion().equals(this.choice) || this.onlyOneChoice()) {
                this.result.update = true;
                return this.result;
            }
            return null;
        }

        @Override
        public boolean onlyOneChoice() {
            return !this.dsNames.contains(this.result.datasourceName);
        }
    }

    static class DatasourceNameStep
    implements Step<Pair<VaultItem, KeyItem>, Result> {
        private Result result = new Result();

        DatasourceNameStep() {
        }

        @Override
        public Step<Pair<VaultItem, KeyItem>, Result> prepare(Pair<VaultItem, KeyItem> item) {
            this.result.vault = (VaultItem)item.first();
            this.result.key = (KeyItem)item.second();
            return this;
        }

        @Override
        public NotifyDescriptor createInput() {
            return new NotifyDescriptor.InputLine("DEFAULT", Bundle.DatasourceName());
        }

        @Override
        public Step getNext() {
            return new OverwriteStep().prepare(this.result);
        }

        @Override
        public void setValue(String selected) {
            this.result.datasourceName = selected;
        }

        @Override
        public Result getValue() {
            return this.result;
        }

        @Override
        public boolean onlyOneChoice() {
            return false;
        }
    }

    static class KeyStep
    implements Step<VaultItem, Pair<VaultItem, KeyItem>> {
        private Map<String, KeyItem> keys = null;
        private KeyItem selected;
        private VaultItem vault;

        KeyStep() {
        }

        @Override
        public Step<VaultItem, Pair<VaultItem, KeyItem>> prepare(VaultItem vault) {
            this.vault = vault;
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
            h.start();
            h.progress(Bundle.MSG_CollectingItems_Text());
            try {
                this.keys = AddDbConnectionToVault.getKeys(vault);
            }
            finally {
                h.finish();
            }
            return this;
        }

        @Override
        public boolean onlyOneChoice() {
            return this.keys.size() == 1;
        }

        @Override
        public NotifyDescriptor createInput() {
            if (this.keys.size() > 1) {
                return AddDbConnectionToVault.createQuickPick(this.keys, Bundle.SelectKey());
            }
            if (this.keys.size() == 0) {
                return new NotifyDescriptor.QuickPick("", Bundle.NoKeys(), Collections.emptyList(), false);
            }
            throw new IllegalStateException("No data to create input");
        }

        @Override
        public Step getNext() {
            return new DatasourceNameStep().prepare(this.getValue());
        }

        @Override
        public void setValue(String selected) {
            this.selected = this.keys.get(selected);
        }

        @Override
        public Pair<VaultItem, KeyItem> getValue() {
            if (this.keys.size() == 1) {
                return Pair.of((Object)this.vault, (Object)this.keys.values().iterator().next());
            }
            return Pair.of((Object)this.vault, (Object)this.selected);
        }
    }

    static class VaultStep
    implements Step<CompartmentItem, VaultItem> {
        private Map<String, VaultItem> vaults = null;
        private VaultItem selected;

        VaultStep() {
        }

        @Override
        public Step<CompartmentItem, VaultItem> prepare(CompartmentItem compartment) {
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
            h.start();
            h.progress(Bundle.MSG_CollectingItems_Text());
            try {
                this.vaults = AddDbConnectionToVault.getVaults(compartment);
            }
            finally {
                h.finish();
            }
            return this;
        }

        @Override
        public NotifyDescriptor createInput() {
            return AddDbConnectionToVault.createQuickPick(this.vaults, Bundle.SelectVault());
        }

        @Override
        public Step getNext() {
            return new KeyStep().prepare(this.selected);
        }

        @Override
        public void setValue(String selected) {
            this.selected = this.vaults.get(selected);
        }

        @Override
        public VaultItem getValue() {
            if (this.onlyOneChoice()) {
                this.vaults.values().iterator().next();
            }
            return this.selected;
        }

        @Override
        public boolean onlyOneChoice() {
            return this.vaults.size() == 1;
        }
    }

    static class CompartmentStep
    implements Step<TenancyItem, CompartmentItem> {
        private Map<String, OCIItem> compartments = null;
        private CompartmentItem selected;

        CompartmentStep() {
        }

        @Override
        public Step<TenancyItem, CompartmentItem> prepare(TenancyItem tenancy) {
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
            h.start();
            h.progress(Bundle.MSG_CollectingItems_Text());
            try {
                this.compartments = AddDbConnectionToVault.getFlatCompartment(tenancy);
            }
            finally {
                h.finish();
            }
            return this;
        }

        @Override
        public NotifyDescriptor createInput() {
            if (this.onlyOneChoice()) {
                throw new IllegalStateException("Input shouldn't be displayed for one choice");
            }
            if (this.compartments.isEmpty()) {
                AddDbConnectionToVault.createQuickPick(this.compartments, Bundle.NoCompartment());
            }
            return AddDbConnectionToVault.createQuickPick(this.compartments, Bundle.SelectCompartment());
        }

        @Override
        public Step getNext() {
            return new VaultStep().prepare(this.getValue());
        }

        @Override
        public void setValue(String selected) {
            this.selected = (CompartmentItem)this.compartments.get(selected);
        }

        @Override
        public CompartmentItem getValue() {
            if (this.onlyOneChoice()) {
                return (CompartmentItem)this.compartments.values().iterator().next();
            }
            return this.selected;
        }

        @Override
        public boolean onlyOneChoice() {
            return this.compartments.size() == 1;
        }
    }

    class TenancyStep
    implements Step<Object, TenancyItem> {
        List<OCIProfile> profiles = new LinkedList<OCIProfile>();
        private AtomicReference<TenancyItem> selected = new AtomicReference();

        TenancyStep() {
        }

        @Override
        public NotifyDescriptor createInput() {
            if (this.onlyOneChoice()) {
                throw new IllegalStateException("No data to create input");
            }
            String title = Bundle.SelectProfile();
            ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(this.profiles.size());
            for (OCIProfile p2 : this.profiles) {
                Tenancy t = p2.getTenancyData();
                if (t == null) continue;
                items.add(new NotifyDescriptor.QuickPick.Item(p2.getId(), Bundle.SelectProfile_Description(t.getName(), t.getHomeRegionKey())));
            }
            if (this.profiles.stream().filter(p -> p.getTenancy().isPresent()).count() == 0L) {
                title = Bundle.NoProfile();
            }
            return new NotifyDescriptor.QuickPick(title, title, items, false);
        }

        @Override
        public Step getNext() {
            return new CompartmentStep().prepare(this.getValue());
        }

        @Override
        public Step<Object, TenancyItem> prepare(Object i) {
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingProfiles());
            h.start();
            h.progress(Bundle.MSG_CollectingProfiles_Text());
            try {
                this.profiles = OCIManager.getDefault().getConnectedProfiles();
            }
            finally {
                h.finish();
            }
            return this;
        }

        @Override
        public void setValue(String selected) {
            for (OCIProfile profile : this.profiles) {
                if (!profile.getId().equals(selected)) continue;
                profile.getTenancy().ifPresent(t -> this.selected.set((TenancyItem)t));
                break;
            }
        }

        @Override
        public TenancyItem getValue() {
            if (this.onlyOneChoice()) {
                return this.profiles.stream().map(p -> p.getTenancy()).filter(Optional::isPresent).map(Optional::get).findFirst().get();
            }
            return this.selected.get();
        }

        @Override
        public boolean onlyOneChoice() {
            return this.profiles.stream().filter(p -> p.getTenancy().isPresent()).count() == 1L;
        }
    }

    static interface Step<T, U> {
        public Step<T, U> prepare(T var1);

        public NotifyDescriptor createInput();

        public boolean onlyOneChoice();

        public Step getNext();

        public void setValue(String var1);

        public U getValue();
    }
}

