/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.common.MethodElement;
import org.netbeans.modules.groovy.editor.completion.provider.CompletionAccessor;
import org.netbeans.modules.groovy.editor.java.Utilities;

public final class TransformationHandler {
    private static final String SINGLETON_ANNOTATION = "Singleton";
    private static final String DELEGATE_ANNOTATION = "Delegate";
    private static final String SINGLETON_FIELD_NAME = "instance";
    private static final String SINGLETON_METHOD_NAME = "getInstance";

    public static Map<FieldSignature, CompletionItem> getFields(GroovyIndex index, ClassNode typeNode, String prefix, int anchorOffset) {
        HashMap<FieldSignature, CompletionItem> result = new HashMap<FieldSignature, CompletionItem>();
        for (AnnotationNode annotation : typeNode.getAnnotations()) {
            String annotationName = annotation.getClassNode().getNameWithoutPackage();
            if (!SINGLETON_ANNOTATION.equals(annotationName)) continue;
            FieldSignature signature = new FieldSignature(SINGLETON_FIELD_NAME);
            CompletionItem.FieldItem proposal = new CompletionItem.FieldItem(typeNode.getNameWithoutPackage(), SINGLETON_FIELD_NAME, 8, anchorOffset);
            if (!signature.getName().startsWith(prefix)) continue;
            result.put(signature, proposal);
        }
        for (FieldNode field : typeNode.getFields()) {
            for (AnnotationNode fieldAnnotation : field.getAnnotations()) {
                String fieldAnnotationName = fieldAnnotation.getClassNode().getNameWithoutPackage();
                if (!DELEGATE_ANNOTATION.equals(fieldAnnotationName)) continue;
                for (FieldNode annotatedField : field.getType().getFields()) {
                    FieldSignature signature = new FieldSignature(annotatedField.getName());
                    CompletionItem.FieldItem fieldProposal = new CompletionItem.FieldItem(annotatedField.getType().getNameWithoutPackage(), annotatedField.getName(), annotatedField.getModifiers(), anchorOffset);
                    if (!signature.getName().startsWith(prefix)) continue;
                    result.put(signature, fieldProposal);
                }
            }
        }
        return result;
    }

    public static Map<MethodSignature, CompletionItem> getMethods(GroovyIndex index, ClassNode typeNode, String prefix, int anchorOffset) {
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        boolean prefixed = !"".equals(prefix);
        for (AnnotationNode annotation : typeNode.getAnnotations()) {
            String annotationName = annotation.getClassNode().getNameWithoutPackage();
            if (!SINGLETON_ANNOTATION.equals(annotationName)) continue;
            MethodSignature signature = new MethodSignature(SINGLETON_METHOD_NAME, new String[0]);
            CompletionItem proposal = CompletionAccessor.instance().createJavaMethod(typeNode.getNameWithoutPackage(), SINGLETON_METHOD_NAME, Collections.emptyList(), typeNode.getNameWithoutPackage(), Utilities.reflectionModifiersToModel(8), anchorOffset, true, false);
            if (!signature.getName().startsWith(prefix)) continue;
            result.put(signature, proposal);
        }
        for (FieldNode field : typeNode.getFields()) {
            for (AnnotationNode fieldAnnotation : field.getAnnotations()) {
                String fieldAnnotationName = fieldAnnotation.getClassNode().getNameWithoutPackage();
                if (!DELEGATE_ANNOTATION.equals(fieldAnnotationName)) continue;
                for (MethodNode method : field.getType().getMethods()) {
                    MethodSignature signature = TransformationHandler.getSignature(method);
                    CompletionItem proposal = TransformationHandler.createMethodProposal(method, prefixed, anchorOffset);
                    if (!signature.getName().startsWith(prefix)) continue;
                    result.put(signature, proposal);
                }
            }
        }
        return result;
    }

    private static MethodSignature getSignature(MethodNode method) {
        String[] parameters = new String[method.getParameters().length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = Utilities.translateClassLoaderTypeName(method.getParameters()[i].getName());
        }
        return new MethodSignature(method.getName(), parameters);
    }

    private static CompletionItem createMethodProposal(MethodNode method, boolean prefixed, int anchorOffset) {
        String methodName = method.getName();
        List<MethodElement.MethodParameter> methodParams = TransformationHandler.getMethodParams(method);
        String returnType = method.getReturnType().getName();
        return CompletionAccessor.instance().createDynamicMethod(anchorOffset, methodName, methodParams, returnType, prefixed);
    }

    private static List<MethodElement.MethodParameter> getMethodParams(MethodNode method) {
        Parameter[] mps;
        ArrayList<MethodElement.MethodParameter> result = new ArrayList<MethodElement.MethodParameter>(method.getParameters().length);
        for (Parameter p : mps = method.getParameters()) {
            result.add(new MethodElement.MethodParameter(p.getType().getName(), p.getType().getNameWithoutPackage(), p.getName()));
        }
        return result;
    }
}

