/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DayOfWeek;
import com.oracle.bmc.database.model.Month;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaintenanceWindow
extends ExplicitlySetBmcModel {
    @JsonProperty(value="preference")
    private final Preference preference;
    @JsonProperty(value="patchingMode")
    private final PatchingMode patchingMode;
    @JsonProperty(value="isCustomActionTimeoutEnabled")
    private final Boolean isCustomActionTimeoutEnabled;
    @JsonProperty(value="customActionTimeoutInMins")
    private final Integer customActionTimeoutInMins;
    @JsonProperty(value="isMonthlyPatchingEnabled")
    private final Boolean isMonthlyPatchingEnabled;
    @JsonProperty(value="months")
    private final List<Month> months;
    @JsonProperty(value="weeksOfMonth")
    private final List<Integer> weeksOfMonth;
    @JsonProperty(value="daysOfWeek")
    private final List<DayOfWeek> daysOfWeek;
    @JsonProperty(value="hoursOfDay")
    private final List<Integer> hoursOfDay;
    @JsonProperty(value="leadTimeInWeeks")
    private final Integer leadTimeInWeeks;

    @Deprecated
    @ConstructorProperties(value={"preference", "patchingMode", "isCustomActionTimeoutEnabled", "customActionTimeoutInMins", "isMonthlyPatchingEnabled", "months", "weeksOfMonth", "daysOfWeek", "hoursOfDay", "leadTimeInWeeks"})
    public MaintenanceWindow(Preference preference, PatchingMode patchingMode, Boolean isCustomActionTimeoutEnabled, Integer customActionTimeoutInMins, Boolean isMonthlyPatchingEnabled, List<Month> months, List<Integer> weeksOfMonth, List<DayOfWeek> daysOfWeek, List<Integer> hoursOfDay, Integer leadTimeInWeeks) {
        this.preference = preference;
        this.patchingMode = patchingMode;
        this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
        this.customActionTimeoutInMins = customActionTimeoutInMins;
        this.isMonthlyPatchingEnabled = isMonthlyPatchingEnabled;
        this.months = months;
        this.weeksOfMonth = weeksOfMonth;
        this.daysOfWeek = daysOfWeek;
        this.hoursOfDay = hoursOfDay;
        this.leadTimeInWeeks = leadTimeInWeeks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Preference getPreference() {
        return this.preference;
    }

    public PatchingMode getPatchingMode() {
        return this.patchingMode;
    }

    public Boolean getIsCustomActionTimeoutEnabled() {
        return this.isCustomActionTimeoutEnabled;
    }

    public Integer getCustomActionTimeoutInMins() {
        return this.customActionTimeoutInMins;
    }

    public Boolean getIsMonthlyPatchingEnabled() {
        return this.isMonthlyPatchingEnabled;
    }

    public List<Month> getMonths() {
        return this.months;
    }

    public List<Integer> getWeeksOfMonth() {
        return this.weeksOfMonth;
    }

    public List<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public List<Integer> getHoursOfDay() {
        return this.hoursOfDay;
    }

    public Integer getLeadTimeInWeeks() {
        return this.leadTimeInWeeks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaintenanceWindow(");
        sb.append("super=").append(super.toString());
        sb.append("preference=").append(String.valueOf((Object)this.preference));
        sb.append(", patchingMode=").append(String.valueOf((Object)this.patchingMode));
        sb.append(", isCustomActionTimeoutEnabled=").append(String.valueOf(this.isCustomActionTimeoutEnabled));
        sb.append(", customActionTimeoutInMins=").append(String.valueOf(this.customActionTimeoutInMins));
        sb.append(", isMonthlyPatchingEnabled=").append(String.valueOf(this.isMonthlyPatchingEnabled));
        sb.append(", months=").append(String.valueOf(this.months));
        sb.append(", weeksOfMonth=").append(String.valueOf(this.weeksOfMonth));
        sb.append(", daysOfWeek=").append(String.valueOf(this.daysOfWeek));
        sb.append(", hoursOfDay=").append(String.valueOf(this.hoursOfDay));
        sb.append(", leadTimeInWeeks=").append(String.valueOf(this.leadTimeInWeeks));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow)((Object)o);
        return Objects.equals((Object)this.preference, (Object)other.preference) && Objects.equals((Object)this.patchingMode, (Object)other.patchingMode) && Objects.equals(this.isCustomActionTimeoutEnabled, other.isCustomActionTimeoutEnabled) && Objects.equals(this.customActionTimeoutInMins, other.customActionTimeoutInMins) && Objects.equals(this.isMonthlyPatchingEnabled, other.isMonthlyPatchingEnabled) && Objects.equals(this.months, other.months) && Objects.equals(this.weeksOfMonth, other.weeksOfMonth) && Objects.equals(this.daysOfWeek, other.daysOfWeek) && Objects.equals(this.hoursOfDay, other.hoursOfDay) && Objects.equals(this.leadTimeInWeeks, other.leadTimeInWeeks) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.preference == null ? 43 : this.preference.hashCode());
        result = result * 59 + (this.patchingMode == null ? 43 : this.patchingMode.hashCode());
        result = result * 59 + (this.isCustomActionTimeoutEnabled == null ? 43 : this.isCustomActionTimeoutEnabled.hashCode());
        result = result * 59 + (this.customActionTimeoutInMins == null ? 43 : this.customActionTimeoutInMins.hashCode());
        result = result * 59 + (this.isMonthlyPatchingEnabled == null ? 43 : this.isMonthlyPatchingEnabled.hashCode());
        result = result * 59 + (this.months == null ? 43 : this.months.hashCode());
        result = result * 59 + (this.weeksOfMonth == null ? 43 : this.weeksOfMonth.hashCode());
        result = result * 59 + (this.daysOfWeek == null ? 43 : this.daysOfWeek.hashCode());
        result = result * 59 + (this.hoursOfDay == null ? 43 : this.hoursOfDay.hashCode());
        result = result * 59 + (this.leadTimeInWeeks == null ? 43 : this.leadTimeInWeeks.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchingMode implements BmcEnum
    {
        Rolling("ROLLING"),
        Nonrolling("NONROLLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchingMode> map;

        private PatchingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchingMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchingMode.class);
            map = new HashMap<String, PatchingMode>();
            for (PatchingMode v : PatchingMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Preference implements BmcEnum
    {
        NoPreference("NO_PREFERENCE"),
        CustomPreference("CUSTOM_PREFERENCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Preference> map;

        private Preference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Preference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Preference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Preference.class);
            map = new HashMap<String, Preference>();
            for (Preference v : Preference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="preference")
        private Preference preference;
        @JsonProperty(value="patchingMode")
        private PatchingMode patchingMode;
        @JsonProperty(value="isCustomActionTimeoutEnabled")
        private Boolean isCustomActionTimeoutEnabled;
        @JsonProperty(value="customActionTimeoutInMins")
        private Integer customActionTimeoutInMins;
        @JsonProperty(value="isMonthlyPatchingEnabled")
        private Boolean isMonthlyPatchingEnabled;
        @JsonProperty(value="months")
        private List<Month> months;
        @JsonProperty(value="weeksOfMonth")
        private List<Integer> weeksOfMonth;
        @JsonProperty(value="daysOfWeek")
        private List<DayOfWeek> daysOfWeek;
        @JsonProperty(value="hoursOfDay")
        private List<Integer> hoursOfDay;
        @JsonProperty(value="leadTimeInWeeks")
        private Integer leadTimeInWeeks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder preference(Preference preference) {
            this.preference = preference;
            this.__explicitlySet__.add("preference");
            return this;
        }

        public Builder patchingMode(PatchingMode patchingMode) {
            this.patchingMode = patchingMode;
            this.__explicitlySet__.add("patchingMode");
            return this;
        }

        public Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            this.__explicitlySet__.add("isCustomActionTimeoutEnabled");
            return this;
        }

        public Builder customActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
            this.__explicitlySet__.add("customActionTimeoutInMins");
            return this;
        }

        public Builder isMonthlyPatchingEnabled(Boolean isMonthlyPatchingEnabled) {
            this.isMonthlyPatchingEnabled = isMonthlyPatchingEnabled;
            this.__explicitlySet__.add("isMonthlyPatchingEnabled");
            return this;
        }

        public Builder months(List<Month> months) {
            this.months = months;
            this.__explicitlySet__.add("months");
            return this;
        }

        public Builder weeksOfMonth(List<Integer> weeksOfMonth) {
            this.weeksOfMonth = weeksOfMonth;
            this.__explicitlySet__.add("weeksOfMonth");
            return this;
        }

        public Builder daysOfWeek(List<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
            this.__explicitlySet__.add("daysOfWeek");
            return this;
        }

        public Builder hoursOfDay(List<Integer> hoursOfDay) {
            this.hoursOfDay = hoursOfDay;
            this.__explicitlySet__.add("hoursOfDay");
            return this;
        }

        public Builder leadTimeInWeeks(Integer leadTimeInWeeks) {
            this.leadTimeInWeeks = leadTimeInWeeks;
            this.__explicitlySet__.add("leadTimeInWeeks");
            return this;
        }

        public MaintenanceWindow build() {
            MaintenanceWindow model = new MaintenanceWindow(this.preference, this.patchingMode, this.isCustomActionTimeoutEnabled, this.customActionTimeoutInMins, this.isMonthlyPatchingEnabled, this.months, this.weeksOfMonth, this.daysOfWeek, this.hoursOfDay, this.leadTimeInWeeks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaintenanceWindow model) {
            if (model.wasPropertyExplicitlySet("preference")) {
                this.preference(model.getPreference());
            }
            if (model.wasPropertyExplicitlySet("patchingMode")) {
                this.patchingMode(model.getPatchingMode());
            }
            if (model.wasPropertyExplicitlySet("isCustomActionTimeoutEnabled")) {
                this.isCustomActionTimeoutEnabled(model.getIsCustomActionTimeoutEnabled());
            }
            if (model.wasPropertyExplicitlySet("customActionTimeoutInMins")) {
                this.customActionTimeoutInMins(model.getCustomActionTimeoutInMins());
            }
            if (model.wasPropertyExplicitlySet("isMonthlyPatchingEnabled")) {
                this.isMonthlyPatchingEnabled(model.getIsMonthlyPatchingEnabled());
            }
            if (model.wasPropertyExplicitlySet("months")) {
                this.months(model.getMonths());
            }
            if (model.wasPropertyExplicitlySet("weeksOfMonth")) {
                this.weeksOfMonth(model.getWeeksOfMonth());
            }
            if (model.wasPropertyExplicitlySet("daysOfWeek")) {
                this.daysOfWeek(model.getDaysOfWeek());
            }
            if (model.wasPropertyExplicitlySet("hoursOfDay")) {
                this.hoursOfDay(model.getHoursOfDay());
            }
            if (model.wasPropertyExplicitlySet("leadTimeInWeeks")) {
                this.leadTimeInWeeks(model.getLeadTimeInWeeks());
            }
            return this;
        }
    }
}

